/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.milvus.common.operator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import plus.jdk.milvus.common.operator.IOperatorComputer;
import plus.jdk.milvus.utils.Converter;

public class JsonArrayOperatorComputer
implements IOperatorComputer {
    private String operator;

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public String compute(String leftValue, Object rightValue, Object identifier, Class<?> clazz) {
        List<Object> params = Converter.objectToList(rightValue, Object.class);
        ArrayList<Object> identifiers = new ArrayList<Object>(Arrays.asList((Object[])identifier));
        String jsonKey = identifiers.stream().map(item -> {
            if (item instanceof String) {
                return "['" + item + "'" + "]";
            }
            if (NumberUtils.isParsable((String)item.toString())) {
                return "[" + item + "]";
            }
            throw new IllegalArgumentException("identifier item must be String or Number");
        }).collect(Collectors.joining());
        String jsonValue = params.stream().map(item -> {
            if (item instanceof String) {
                return "'" + item + "'";
            }
            if (NumberUtils.isParsable((String)item.toString())) {
                return item.toString();
            }
            throw new IllegalArgumentException("identifier item must be String or Number");
        }).collect(Collectors.joining(","));
        return String.format("%s(%s%s, [%s])", this.operator, leftValue, jsonKey, jsonValue);
    }

    public JsonArrayOperatorComputer(String operator) {
        this.operator = operator;
    }
}

