/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.milvus.common;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.jdk.milvus.common.ClassUtils;
import plus.jdk.milvus.common.LambdaMeta;
import plus.jdk.milvus.common.MilvusException;
import plus.jdk.milvus.common.ReflectionKit;

public class ReflectLambdaMeta
implements LambdaMeta {
    private static final Logger log;
    private static final Field FIELD_CAPTURING_CLASS;
    private final SerializedLambda lambda;

    public ReflectLambdaMeta(SerializedLambda lambda) {
        this.lambda = lambda;
    }

    @Override
    public String getImplMethodName() {
        return this.lambda.getImplMethodName();
    }

    @Override
    public Class<?> getInstantiatedClass() {
        String instantiatedMethodType = this.lambda.getInstantiatedMethodType();
        String instantiatedType = instantiatedMethodType.substring(2, instantiatedMethodType.indexOf(";")).replace("/", ".");
        return ClassUtils.toClassConfident(instantiatedType, this.getCapturingClassClassLoader());
    }

    private ClassLoader getCapturingClassClassLoader() {
        if (FIELD_CAPTURING_CLASS == null) {
            return null;
        }
        try {
            return ((Class)FIELD_CAPTURING_CLASS.get(this.lambda)).getClassLoader();
        }
        catch (IllegalAccessException e) {
            throw new MilvusException(e.getMessage());
        }
    }

    static {
        Field fieldCapturingClass;
        log = LoggerFactory.getLogger(ReflectLambdaMeta.class);
        try {
            Class<SerializedLambda> aClass = SerializedLambda.class;
            fieldCapturingClass = ReflectionKit.setAccessible(aClass.getDeclaredField("capturingClass"));
        }
        catch (Throwable e) {
            log.warn(e.getMessage());
            fieldCapturingClass = null;
        }
        FIELD_CAPTURING_CLASS = fieldCapturingClass;
    }
}

