/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.milvus.global;

import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.gson.Gson;
import io.milvus.client.MilvusServiceClient;
import io.milvus.grpc.DataType;
import io.milvus.grpc.GetLoadStateResponse;
import io.milvus.grpc.GetLoadingProgressResponse;
import io.milvus.grpc.LoadState;
import io.milvus.grpc.MutationResult;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.SearchResults;
import io.milvus.param.ConnectParam;
import io.milvus.param.R;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.FieldType;
import io.milvus.param.collection.GetLoadStateParam;
import io.milvus.param.collection.GetLoadingProgressParam;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.collection.ReleaseCollectionParam;
import io.milvus.param.dml.DeleteParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.param.index.DropIndexParam;
import io.milvus.response.QueryResultsWrapper;
import io.milvus.response.SearchResultsWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import plus.jdk.cli.common.StringUtils;
import plus.jdk.milvus.annotation.VectorCollectionColumn;
import plus.jdk.milvus.annotation.VectorCollectionName;
import plus.jdk.milvus.common.MilvusException;
import plus.jdk.milvus.common.Operator;
import plus.jdk.milvus.config.MilvusPlusProperties;
import plus.jdk.milvus.global.VectorTypeHandler;
import plus.jdk.milvus.model.CollectionDefinition;
import plus.jdk.milvus.model.ColumnDefinition;
import plus.jdk.milvus.model.IIndexExtra;
import plus.jdk.milvus.record.VectorModel;
import plus.jdk.milvus.wrapper.LambdaQueryWrapper;
import plus.jdk.milvus.wrapper.LambdaSearchWrapper;

@Service
public class MilvusClientService {
    private static final Logger log = LoggerFactory.getLogger(MilvusClientService.class);
    private final MilvusPlusProperties properties;
    private final MilvusServiceClient milvusClient;
    private final BeanFactory beanFactory;
    private final ApplicationContext applicationContext;
    private final Gson gson = new Gson();
    private final Map<Class<?>, CollectionDefinition> tableDefinitionMap = new ConcurrentHashMap();

    public String getColumnName(SFunction<?, ?> column, Class<?> clazz) throws MilvusException {
        LambdaMeta lambdaMeta = LambdaUtils.extract(column);
        String attributeName = PropertyNamer.methodToProperty((String)lambdaMeta.getImplMethodName());
        Field field = null;
        try {
            field = clazz.getDeclaredField(attributeName);
        }
        catch (Exception e) {
            throw new MilvusException(String.format("unknown attributeName '%s'", attributeName));
        }
        VectorCollectionColumn vectorCollectionColumn = field.getDeclaredAnnotation(VectorCollectionColumn.class);
        if (vectorCollectionColumn == null) {
            throw new MilvusException("table column must annotation with @VectorCollectionColumn");
        }
        return vectorCollectionColumn.name();
    }

    public MilvusClientService(MilvusPlusProperties properties, BeanFactory beanFactory, ApplicationContext applicationContext) {
        ConnectParam.Builder builder = ConnectParam.newBuilder();
        if (properties.getHost() != null) {
            builder.withHost(properties.getHost());
        }
        if (properties.getPort() != null) {
            builder.withPort(properties.getPort().intValue());
        }
        if (properties.getUserName() != null) {
            builder.withAuthorization(properties.getUserName(), properties.getPassword());
        }
        if (properties.getConnectUri() != null) {
            builder.withUri(properties.getConnectUri());
        }
        if (properties.getConnectTimeout() != null) {
            builder.withConnectTimeout(properties.getConnectTimeout().longValue(), TimeUnit.MILLISECONDS);
        }
        if (properties.getRpcDeadline() != null) {
            builder.withRpcDeadline(properties.getRpcDeadline().longValue(), TimeUnit.MILLISECONDS);
        }
        if (properties.getDatabase() != null) {
            builder.withDatabaseName(properties.getDatabase());
        }
        if (properties.getSecure() != null) {
            builder.withSecure(properties.getSecure().booleanValue());
        }
        if (properties.getKeepAliveTime() != null) {
            builder.withKeepAliveTime(properties.getKeepAliveTime().longValue(), TimeUnit.MILLISECONDS);
        }
        if (properties.getIdleTimeout() != null) {
            builder.withIdleTimeout(properties.getIdleTimeout().longValue(), TimeUnit.MILLISECONDS);
        }
        if (properties.getToken() != null) {
            builder.withToken(properties.getToken());
        }
        this.properties = properties;
        this.beanFactory = beanFactory;
        this.applicationContext = applicationContext;
        this.milvusClient = new MilvusServiceClient(builder.build());
    }

    protected List<Field> getDeclaredFields(Class<?> clazz, List<Field> fields) {
        if (clazz == null) {
            return fields;
        }
        fields.addAll(Arrays.asList(this.getClass().getDeclaredFields()));
        this.getDeclaredFields(clazz.getSuperclass(), fields);
        return fields;
    }

    public <T extends VectorModel<?>> CollectionDefinition getTableDefinition(Class<T> clazz) throws MilvusException {
        Field[] clazzFields;
        if (this.tableDefinitionMap.containsKey(clazz)) {
            return this.tableDefinitionMap.get(clazz);
        }
        CollectionDefinition collectionDefinition = new CollectionDefinition();
        VectorCollectionName vectorCollectionName = clazz.getAnnotation(VectorCollectionName.class);
        if (vectorCollectionName == null) {
            throw new MilvusException("table model must annotation with @VectorCollectionName");
        }
        collectionDefinition.setDescription(vectorCollectionName.description());
        collectionDefinition.setName(vectorCollectionName.name());
        collectionDefinition.setDatabase(vectorCollectionName.database());
        collectionDefinition.setClazz(clazz);
        for (Field field : clazzFields = clazz.getDeclaredFields()) {
            ReflectionUtils.makeAccessible((Field)field);
            VectorCollectionColumn tableColumn = field.getDeclaredAnnotation(VectorCollectionColumn.class);
            if (tableColumn == null) continue;
            String columnName = tableColumn.name();
            VectorTypeHandler vectorTypeHandler = (VectorTypeHandler)this.beanFactory.getBean(tableColumn.EmbeddingTypeHandler());
            ColumnDefinition columnDefinition = new ColumnDefinition();
            columnDefinition.setDesc(tableColumn.desc());
            columnDefinition.setName(columnName);
            columnDefinition.setPrimary(tableColumn.primary());
            columnDefinition.setDataType(tableColumn.dataType());
            columnDefinition.setVectorTypeHandler(vectorTypeHandler);
            columnDefinition.setField(field);
            columnDefinition.setPartitionKey(tableColumn.partitionKey());
            columnDefinition.setVectorDimension(tableColumn.vectorDimension());
            columnDefinition.setMaxLength(tableColumn.maxLength());
            columnDefinition.setIndex(tableColumn.index());
            columnDefinition.setIndexType(tableColumn.indexType());
            columnDefinition.setMetricType(tableColumn.metricType());
            collectionDefinition.getColumns().add(columnDefinition);
        }
        this.tableDefinitionMap.put(clazz, collectionDefinition);
        return collectionDefinition;
    }

    public <T extends VectorModel<?>> boolean remove(Object pk, Class<T> clazz) throws MilvusException {
        CollectionDefinition collection = this.getTableDefinition(clazz);
        String columnName = collection.getPrimaryColumn().getName();
        String expression = Operator.in.getIOperatorComputer().compute(columnName, new Object[]{pk}, clazz);
        if (StringUtils.isEmpty((String)expression)) {
            throw new MilvusException("expression is null");
        }
        DeleteParam.Builder builder = DeleteParam.newBuilder().withCollectionName(collection.getName()).withExpr(expression);
        R resultR = this.milvusClient.delete(builder.build());
        if (resultR.getStatus().intValue() != R.Status.Success.getCode() || resultR.getException() != null) {
            throw new MilvusException(resultR.getException().getMessage());
        }
        return true;
    }

    public <T extends VectorModel<?>> boolean batchRemove(LambdaQueryWrapper<T> wrapper, Class<T> clazz) throws MilvusException {
        CollectionDefinition collection = this.getTableDefinition(clazz);
        String expression = wrapper.buildExpression(clazz);
        if (StringUtils.isEmpty((String)expression)) {
            throw new MilvusException("expression is null");
        }
        DeleteParam.Builder builder = DeleteParam.newBuilder().withCollectionName(collection.getName()).withExpr(expression);
        R resultR = this.milvusClient.delete(builder.build());
        if (resultR.getStatus().intValue() != R.Status.Success.getCode() || resultR.getException() != null) {
            throw new MilvusException(resultR.getException().getMessage());
        }
        return true;
    }

    public <T extends VectorModel<?>> Boolean insert(T vectorModel) throws MilvusException {
        CollectionDefinition collectionDefinition = this.getTableDefinition(vectorModel.getClass());
        InsertParam.Builder builder = InsertParam.newBuilder();
        ArrayList<InsertParam.Field> dataFields = new ArrayList<InsertParam.Field>();
        for (ColumnDefinition columnDefinition : collectionDefinition.getColumns()) {
            ReflectionUtils.makeAccessible((Field)columnDefinition.getField());
            String columnName = columnDefinition.getName();
            Object value = ReflectionUtils.getField((Field)columnDefinition.getField(), vectorModel);
            if (value == null) continue;
            VectorTypeHandler<?, ?> vectorTypeHandler = columnDefinition.getVectorTypeHandler();
            List<?> dataVector = vectorTypeHandler.serialize(value);
            dataFields.add(new InsertParam.Field(columnName, dataVector));
        }
        if (!StringUtils.isEmpty((String)collectionDefinition.getDatabase())) {
            builder.withDatabaseName(collectionDefinition.getDatabase());
        }
        builder.withCollectionName(collectionDefinition.getName());
        builder.withFields(dataFields);
        InsertParam insertParam = builder.build();
        R resultR = this.milvusClient.insert(insertParam);
        if (resultR.getStatus().intValue() != R.Status.Success.getCode() || resultR.getException() != null) {
            throw new MilvusException(resultR.getException().getMessage());
        }
        if (resultR.getData() != null && ((MutationResult)resultR.getData()).getIDs().getIntId().getDataList().size() > 0) {
            ColumnDefinition column = collectionDefinition.getPrimaryColumn();
            ReflectionUtils.makeAccessible((Field)column.getField());
            Object id = ((MutationResult)resultR.getData()).getIDs().getIntId().getDataList().get(0);
            ReflectionUtils.setField((Field)column.getField(), vectorModel, id);
        }
        return true;
    }

    public <T extends VectorModel<?>> void loadCollection(Class<T> clazz) throws MilvusException {
        R resultR;
        CollectionDefinition collectionDefinition = this.getTableDefinition(clazz);
        LoadCollectionParam.Builder builder = LoadCollectionParam.newBuilder();
        builder.withCollectionName(collectionDefinition.getName());
        if (!StringUtils.isEmpty((String)collectionDefinition.getDatabase())) {
            builder.withDatabaseName(collectionDefinition.getDatabase());
        }
        if ((resultR = this.milvusClient.loadCollection(builder.build())).getStatus().intValue() != R.Status.Success.getCode() || resultR.getException() != null) {
            throw new MilvusException(resultR.getException().getMessage());
        }
    }

    public <T extends VectorModel<?>> void releaseCollection(Class<T> clazz) throws MilvusException {
        CollectionDefinition collectionDefinition = this.getTableDefinition(clazz);
        this.milvusClient.releaseCollection(ReleaseCollectionParam.newBuilder().withCollectionName(collectionDefinition.getName()).build());
    }

    public <T extends VectorModel<?>> void dropCollection(Class<T> clazz) throws MilvusException {
        R resultR;
        CollectionDefinition collectionDefinition = this.getTableDefinition(clazz);
        DropCollectionParam.Builder builder = DropCollectionParam.newBuilder().withCollectionName(collectionDefinition.getName());
        if (!StringUtils.isEmpty((String)collectionDefinition.getDatabase())) {
            builder.withDatabaseName(collectionDefinition.getDatabase());
        }
        if ((resultR = this.milvusClient.dropCollection(builder.build())).getStatus().intValue() != R.Status.Success.getCode() || resultR.getException() != null) {
            throw new MilvusException(resultR.getException().getMessage());
        }
    }

    public <T extends VectorModel<?>> boolean hasCollection(Class<T> clazz) throws MilvusException {
        R resultR;
        CollectionDefinition collectionDefinition = this.getTableDefinition(clazz);
        HasCollectionParam.Builder builder = HasCollectionParam.newBuilder().withCollectionName(collectionDefinition.getName());
        if (!StringUtils.isEmpty((String)collectionDefinition.getDatabase())) {
            builder.withDatabaseName(collectionDefinition.getDatabase());
        }
        if ((resultR = this.milvusClient.hasCollection(builder.build())).getStatus().intValue() != R.Status.Success.getCode() || resultR.getException() != null) {
            throw new MilvusException(resultR.getException().getMessage());
        }
        return (Boolean)resultR.getData();
    }

    public <T extends VectorModel<?>> boolean dropIndex(Class<T> clazz, String indexName) throws MilvusException {
        CollectionDefinition collectionDefinition = this.getTableDefinition(clazz);
        DropIndexParam.Builder builder = DropIndexParam.newBuilder().withCollectionName(collectionDefinition.getName()).withIndexName(indexName);
        R resultR = this.milvusClient.dropIndex(builder.build());
        if (resultR.getStatus().intValue() != R.Status.Success.getCode() || resultR.getException() != null) {
            throw new MilvusException(resultR.getException().getMessage());
        }
        return true;
    }

    public <T extends VectorModel<?>> LoadState getLoadState(Class<T> clazz) throws MilvusException {
        R resultR;
        CollectionDefinition collectionDefinition = this.getTableDefinition(clazz);
        GetLoadStateParam.Builder builder = GetLoadStateParam.newBuilder();
        builder.withCollectionName(collectionDefinition.getName());
        if (!StringUtils.isEmpty((String)collectionDefinition.getDatabase())) {
            builder.withDatabaseName(collectionDefinition.getDatabase());
        }
        if ((resultR = this.milvusClient.getLoadState(builder.build())).getStatus().intValue() != R.Status.Success.getCode() || resultR.getException() != null) {
            throw new MilvusException(resultR.getException().getMessage());
        }
        return ((GetLoadStateResponse)resultR.getData()).getState();
    }

    public <T extends VectorModel<?>> Long getLoadProgress(Class<T> clazz) throws MilvusException {
        CollectionDefinition collectionDefinition = this.getTableDefinition(clazz);
        GetLoadingProgressParam.Builder builder = GetLoadingProgressParam.newBuilder();
        builder.withCollectionName(collectionDefinition.getName());
        R resultR = this.milvusClient.getLoadingProgress(builder.build());
        if (resultR.getStatus().intValue() != R.Status.Success.getCode() || resultR.getException() != null) {
            throw new MilvusException(resultR.getException().getMessage());
        }
        return ((GetLoadingProgressResponse)resultR.getData()).getProgress();
    }

    public <T extends VectorModel<?>> boolean createIndex(Class<T> clazz, String indexName, SFunction<?, ?> column, IIndexExtra extra) throws MilvusException {
        CollectionDefinition collectionDefinition = this.getTableDefinition(clazz);
        CreateIndexParam.Builder builder = CreateIndexParam.newBuilder();
        builder.withCollectionName(collectionDefinition.getName());
        String columnName = this.getColumnName(column, clazz);
        ColumnDefinition columnDefinition = collectionDefinition.getColumnByColumnName(columnName);
        builder.withFieldName(columnName);
        builder.withIndexName(indexName);
        builder.withIndexType(columnDefinition.getIndexType());
        builder.withMetricType(columnDefinition.getMetricType());
        if (extra != null) {
            builder.withExtraParam(new Gson().toJson((Object)extra));
        }
        builder.withSyncMode(Boolean.FALSE);
        R resultR = this.milvusClient.createIndex(builder.build());
        if (resultR.getStatus().intValue() != R.Status.Success.getCode() || resultR.getException() != null) {
            throw new MilvusException(resultR.getException().getMessage());
        }
        return true;
    }

    public <T extends VectorModel<?>> boolean createCollection(Class<T> clazz) throws MilvusException {
        CollectionDefinition collectionDefinition = this.getTableDefinition(clazz);
        CreateCollectionParam.Builder builder = CreateCollectionParam.newBuilder();
        builder.withCollectionName(collectionDefinition.getName());
        builder.withDescription(collectionDefinition.getDescription());
        for (ColumnDefinition column : collectionDefinition.getColumns()) {
            FieldType.Builder fieldBuilder = FieldType.newBuilder();
            fieldBuilder.withName(column.getName());
            fieldBuilder.withDescription(column.getDesc());
            fieldBuilder.withPartitionKey(column.getPartitionKey().booleanValue());
            fieldBuilder.withDataType(column.getDataType());
            fieldBuilder.withPrimaryKey(column.getPrimary().booleanValue());
            if (column.vectorColumn()) {
                fieldBuilder.withDimension(column.getVectorDimension());
            }
            if (column.getDataType() == DataType.VarChar) {
                fieldBuilder.withMaxLength(column.getMaxLength());
            }
            if (column.getPrimary().booleanValue()) {
                fieldBuilder.withAutoID(true);
            }
            if (column.canBePartitionKey()) {
                fieldBuilder.withPartitionKey(column.getPartitionKey().booleanValue());
            }
            builder.addFieldType(fieldBuilder.build());
        }
        R resultR = this.milvusClient.createCollection(builder.build());
        if (resultR.getStatus().intValue() != R.Status.Success.getCode() || resultR.getException() != null) {
            throw new MilvusException(resultR.getException().getMessage());
        }
        return true;
    }

    private <T extends VectorModel<?>> T createInstance(Class<T> clazz) throws MilvusException {
        try {
            return (T)((VectorModel)clazz.newInstance());
        }
        catch (Exception e) {
            throw new MilvusException(e.getMessage());
        }
    }

    public <T extends VectorModel<?>> List<T> search(LambdaSearchWrapper<T> wrapper, Class<T> clazz) throws MilvusException {
        R resultR;
        CollectionDefinition collectionDefinition = this.getTableDefinition(clazz);
        ArrayList<String> outFields = new ArrayList<String>();
        for (ColumnDefinition columnDefinition : collectionDefinition.getColumns()) {
            if (columnDefinition.vectorColumn()) continue;
            outFields.add(columnDefinition.getName());
        }
        SearchParam.Builder builder = SearchParam.newBuilder();
        String vectorColumnName = this.getColumnName(wrapper.getVectorColumn(), clazz);
        ColumnDefinition columnDefinition = collectionDefinition.getColumnByColumnName(vectorColumnName);
        VectorTypeHandler<?, ?> vectorTypeHandler = columnDefinition.getVectorTypeHandler();
        List<?> vectors = vectorTypeHandler.serialize(wrapper.getVectorValue());
        builder.withVectors(vectors);
        builder.withVectorFieldName(columnDefinition.getName());
        builder.withCollectionName(collectionDefinition.getName());
        builder.withConsistencyLevel(wrapper.getConsistencyLevel());
        builder.withMetricType(columnDefinition.getMetricType());
        builder.withOutFields(outFields);
        builder.withTopK(wrapper.getTopK());
        String expression = wrapper.buildExpression(clazz);
        if (!StringUtils.isEmpty((String)expression)) {
            builder.withExpr(expression);
        }
        if (!CollectionUtils.isEmpty(wrapper.getPartitionNames())) {
            builder.withPartitionNames(wrapper.getPartitionNames());
        }
        if (wrapper.getTravelTimestamp() != null) {
            builder.withTravelTimestamp(wrapper.getTravelTimestamp());
        }
        if (wrapper.getGracefulTime() != null) {
            builder.withGracefulTime(wrapper.getGracefulTime());
        }
        if (wrapper.getIgnoreGrowing() != null) {
            builder.withGracefulTime(wrapper.getIgnoreGrowing());
        }
        if (wrapper.getExtra() != null) {
            builder.withParams(this.gson.toJson((Object)wrapper.getExtra()));
        }
        if ((resultR = this.milvusClient.search(builder.build())).getStatus().intValue() != R.Status.Success.getCode() || resultR.getException() != null) {
            throw new MilvusException(resultR.getException().getMessage());
        }
        SearchResultsWrapper resultsWrapper = new SearchResultsWrapper(((SearchResults)resultR.getData()).getResults());
        ArrayList<T> resultRows = new ArrayList<T>();
        for (int i = 0; i < resultsWrapper.getRowRecords().size(); ++i) {
            QueryResultsWrapper.RowRecord rowRecord = (QueryResultsWrapper.RowRecord)resultsWrapper.getRowRecords().get(i);
            T data = this.createInstance(clazz);
            Object distance = rowRecord.get("distance");
            if (distance instanceof Float) {
                ((VectorModel)data).setDistance((Float)rowRecord.get("distance"));
            }
            for (String columnName : rowRecord.getFieldValues().keySet()) {
                ColumnDefinition column = collectionDefinition.getColumnByColumnName(columnName);
                if (column == null) continue;
                ReflectionUtils.makeAccessible((Field)column.getField());
                ReflectionUtils.setField((Field)column.getField(), data, (Object)rowRecord.get(columnName));
            }
            resultRows.add(data);
        }
        return resultRows;
    }

    public <T extends VectorModel<?>> List<T> query(LambdaQueryWrapper<T> wrapper, Class<T> clazz) throws MilvusException {
        R resultR;
        String expression;
        CollectionDefinition collectionDefinition = this.getTableDefinition(clazz);
        ArrayList<String> outFields = new ArrayList<String>();
        for (ColumnDefinition columnDefinition : collectionDefinition.getColumns()) {
            if (columnDefinition.vectorColumn()) continue;
            outFields.add(columnDefinition.getName());
        }
        QueryParam.Builder builder = QueryParam.newBuilder();
        if (!CollectionUtils.isEmpty(wrapper.getPartitionNames())) {
            builder.withPartitionNames(wrapper.getPartitionNames());
        }
        if (!CollectionUtils.isEmpty(wrapper.getPartitionNames())) {
            builder.withPartitionNames(wrapper.getPartitionNames());
        }
        if (wrapper.getTravelTimestamp() != null) {
            builder.withTravelTimestamp(wrapper.getTravelTimestamp());
        }
        if (wrapper.getGracefulTime() != null) {
            builder.withGracefulTime(wrapper.getGracefulTime());
        }
        if (wrapper.getIgnoreGrowing() != null) {
            builder.withGracefulTime(wrapper.getIgnoreGrowing());
        }
        builder.withCollectionName(collectionDefinition.getName());
        builder.withConsistencyLevel(wrapper.getConsistencyLevel());
        builder.withOutFields(outFields);
        if (wrapper.getLimit() != null) {
            builder.withLimit(wrapper.getLimit());
        }
        if (wrapper.getOffset() != null) {
            builder.withOffset(wrapper.getOffset());
        }
        if (!StringUtils.isEmpty((String)(expression = wrapper.buildExpression(clazz)))) {
            builder.withExpr(expression);
        }
        if ((resultR = this.milvusClient.query(builder.build())).getStatus().intValue() != R.Status.Success.getCode() || resultR.getException() != null) {
            throw new MilvusException(resultR.getException().getMessage());
        }
        QueryResultsWrapper resultsWrapper = new QueryResultsWrapper((QueryResults)resultR.getData());
        ArrayList<T> resultRows = new ArrayList<T>();
        for (int i = 0; i < resultsWrapper.getRowRecords().size(); ++i) {
            QueryResultsWrapper.RowRecord rowRecord = (QueryResultsWrapper.RowRecord)resultsWrapper.getRowRecords().get(i);
            T data = this.createInstance(clazz);
            for (String columnName : rowRecord.getFieldValues().keySet()) {
                ColumnDefinition column = collectionDefinition.getColumnByColumnName(columnName);
                if (column == null) continue;
                ReflectionUtils.makeAccessible((Field)column.getField());
                ReflectionUtils.setField((Field)column.getField(), data, (Object)rowRecord.get(columnName));
            }
            resultRows.add(data);
        }
        return resultRows;
    }
}

