/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.milvus.wrapper;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import java.util.ArrayList;
import java.util.List;
import plus.jdk.milvus.common.MilvusException;
import plus.jdk.milvus.common.Operator;
import plus.jdk.milvus.global.MilvusClientService;
import plus.jdk.milvus.model.WrapperModel;
import plus.jdk.milvus.record.VectorModel;
import plus.jdk.milvus.selector.MilvusSelector;

public abstract class AbstractLambdaWrapper<T extends VectorModel<?>> {
    private final List<WrapperModel<T>> wrapperModels = new ArrayList<WrapperModel<T>>();
    private ConsistencyLevelEnum consistencyLevel = ConsistencyLevelEnum.STRONG;
    private List<String> partitionNames = new ArrayList<String>();
    private Long travelTimestamp;
    private Long gracefulTime;
    private Long ignoreGrowing;

    protected String getTableColumnName(SFunction<?, ?> column, Class<?> clazz) throws MilvusException {
        MilvusClientService milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return milvusClientService.getColumnName(column, clazz);
    }

    public <R> AbstractLambdaWrapper<T> eq(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.eq, value));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> le(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.le, value));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> lt(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.lt, value));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> ge(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.ge, value));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> gt(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.gt, value));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> ne(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.ne, value));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> like(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.like, value));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> not_like(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.not_like, value));
        return this;
    }

    public AbstractLambdaWrapper<T> and(AbstractLambdaWrapper<T> ... wrappers) {
        this.wrapperModels.add(new WrapperModel(null, Operator.and, wrappers));
        return this;
    }

    public AbstractLambdaWrapper<T> or(AbstractLambdaWrapper<T> ... wrappers) {
        this.wrapperModels.add(new WrapperModel(null, Operator.or, wrappers));
        return this;
    }

    public AbstractLambdaWrapper<T> not(AbstractLambdaWrapper<T> ... wrappers) {
        this.wrapperModels.add(new WrapperModel(null, Operator.not, wrappers));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> in(SFunction<T, R> column, R ... values) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.in, values));
        return this;
    }

    public String buildExpression(Class<?> clazz) throws MilvusException {
        ArrayList<String> results = new ArrayList<String>();
        for (WrapperModel<T> wrapperModel : this.wrapperModels) {
            Operator operator = wrapperModel.getOperator();
            String columnName = this.getTableColumnName(wrapperModel.getColumn(), clazz);
            results.add(operator.getIOperatorComputer().compute(columnName, wrapperModel.getValue(), clazz));
        }
        return String.join((CharSequence)" and ", results);
    }

    public List<WrapperModel<T>> getWrapperModels() {
        return this.wrapperModels;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public void setPartitionNames(List<String> partitionNames) {
        this.partitionNames = partitionNames;
    }

    public Long getTravelTimestamp() {
        return this.travelTimestamp;
    }

    public void setTravelTimestamp(Long travelTimestamp) {
        this.travelTimestamp = travelTimestamp;
    }

    public Long getGracefulTime() {
        return this.gracefulTime;
    }

    public void setGracefulTime(Long gracefulTime) {
        this.gracefulTime = gracefulTime;
    }

    public Long getIgnoreGrowing() {
        return this.ignoreGrowing;
    }

    public void setIgnoreGrowing(Long ignoreGrowing) {
        this.ignoreGrowing = ignoreGrowing;
    }
}

