/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.milvus.model;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import io.milvus.grpc.DataType;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import java.lang.reflect.Field;
import plus.jdk.milvus.global.VectorTypeHandler;

public class ColumnDefinition {
    private Boolean primary;
    private String name;
    private DataType dataType;
    private VectorTypeHandler<?, ?> vectorTypeHandler;
    private String desc;
    private SFunction<?, ?> column;
    private Field field;
    private Integer vectorDimension = 1024;
    private Integer maxLength = 128;
    private Boolean partitionKey = false;
    private boolean index = false;
    private IndexType indexType = IndexType.HNSW;
    private MetricType metricType = MetricType.L2;

    public boolean canBePartitionKey() {
        return this.dataType == DataType.Int64 || this.dataType == DataType.VarChar;
    }

    public boolean vectorColumn() {
        return DataType.BinaryVector == this.dataType || DataType.FloatVector == this.dataType;
    }

    public Boolean getPrimary() {
        return this.primary;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public VectorTypeHandler<?, ?> getVectorTypeHandler() {
        return this.vectorTypeHandler;
    }

    public String getDesc() {
        return this.desc;
    }

    public SFunction<?, ?> getColumn() {
        return this.column;
    }

    public Field getField() {
        return this.field;
    }

    public Integer getVectorDimension() {
        return this.vectorDimension;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Boolean getPartitionKey() {
        return this.partitionKey;
    }

    public boolean isIndex() {
        return this.index;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setVectorTypeHandler(VectorTypeHandler<?, ?> vectorTypeHandler) {
        this.vectorTypeHandler = vectorTypeHandler;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setColumn(SFunction<?, ?> column) {
        this.column = column;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setVectorDimension(Integer vectorDimension) {
        this.vectorDimension = vectorDimension;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setPartitionKey(Boolean partitionKey) {
        this.partitionKey = partitionKey;
    }

    public void setIndex(boolean index) {
        this.index = index;
    }

    public void setIndexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public void setMetricType(MetricType metricType) {
        this.metricType = metricType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnDefinition)) {
            return false;
        }
        ColumnDefinition other = (ColumnDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIndex() != other.isIndex()) {
            return false;
        }
        Boolean this$primary = this.getPrimary();
        Boolean other$primary = other.getPrimary();
        if (this$primary == null ? other$primary != null : !((Object)this$primary).equals(other$primary)) {
            return false;
        }
        Integer this$vectorDimension = this.getVectorDimension();
        Integer other$vectorDimension = other.getVectorDimension();
        if (this$vectorDimension == null ? other$vectorDimension != null : !((Object)this$vectorDimension).equals(other$vectorDimension)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Boolean this$partitionKey = this.getPartitionKey();
        Boolean other$partitionKey = other.getPartitionKey();
        if (this$partitionKey == null ? other$partitionKey != null : !((Object)this$partitionKey).equals(other$partitionKey)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        VectorTypeHandler<?, ?> this$vectorTypeHandler = this.getVectorTypeHandler();
        VectorTypeHandler<?, ?> other$vectorTypeHandler = other.getVectorTypeHandler();
        if (this$vectorTypeHandler == null ? other$vectorTypeHandler != null : !this$vectorTypeHandler.equals(other$vectorTypeHandler)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        SFunction<?, ?> this$column = this.getColumn();
        SFunction<?, ?> other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        Field this$field = this.getField();
        Field other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        IndexType this$indexType = this.getIndexType();
        IndexType other$indexType = other.getIndexType();
        if (this$indexType == null ? other$indexType != null : !this$indexType.equals(other$indexType)) {
            return false;
        }
        MetricType this$metricType = this.getMetricType();
        MetricType other$metricType = other.getMetricType();
        return !(this$metricType == null ? other$metricType != null : !this$metricType.equals(other$metricType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIndex() ? 79 : 97);
        Boolean $primary = this.getPrimary();
        result = result * 59 + ($primary == null ? 43 : ((Object)$primary).hashCode());
        Integer $vectorDimension = this.getVectorDimension();
        result = result * 59 + ($vectorDimension == null ? 43 : ((Object)$vectorDimension).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Boolean $partitionKey = this.getPartitionKey();
        result = result * 59 + ($partitionKey == null ? 43 : ((Object)$partitionKey).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        VectorTypeHandler<?, ?> $vectorTypeHandler = this.getVectorTypeHandler();
        result = result * 59 + ($vectorTypeHandler == null ? 43 : $vectorTypeHandler.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        SFunction<?, ?> $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        Field $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        IndexType $indexType = this.getIndexType();
        result = result * 59 + ($indexType == null ? 43 : $indexType.hashCode());
        MetricType $metricType = this.getMetricType();
        result = result * 59 + ($metricType == null ? 43 : $metricType.hashCode());
        return result;
    }

    public String toString() {
        return "ColumnDefinition(primary=" + this.getPrimary() + ", name=" + this.getName() + ", dataType=" + this.getDataType() + ", vectorTypeHandler=" + this.getVectorTypeHandler() + ", desc=" + this.getDesc() + ", column=" + this.getColumn() + ", field=" + this.getField() + ", vectorDimension=" + this.getVectorDimension() + ", maxLength=" + this.getMaxLength() + ", partitionKey=" + this.getPartitionKey() + ", index=" + this.isIndex() + ", indexType=" + this.getIndexType() + ", metricType=" + this.getMetricType() + ")";
    }
}

