/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.scheduled.global;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import plus.jdk.scheduled.annotation.Scheduled;
import plus.jdk.scheduled.config.ScheduledConfig;
import plus.jdk.scheduled.decider.IScheduledDecider;
import plus.jdk.scheduled.global.IScheduled;
import plus.jdk.scheduled.model.ScheduledDefinition;

public class ScheduleInitFactory
implements SchedulingConfigurer {
    private final BeanFactory beanFactory;
    private final ApplicationContext applicationContext;
    private final ScheduledConfig properties;
    private Set<ScheduledDefinition> scheduledDefinitions = new HashSet<ScheduledDefinition>();

    public ScheduleInitFactory(BeanFactory beanFactory, ApplicationContext applicationContext, ScheduledConfig properties) {
        this.beanFactory = beanFactory;
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    protected void initAndRegisterTask() {
        String[] beanNames;
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForAnnotation(Scheduled.class)) {
            IScheduled beanInstance = (IScheduled)this.applicationContext.getBean(beanName, IScheduled.class);
            Scheduled scheduled = (Scheduled)this.applicationContext.findAnnotationOnBean(beanName, Scheduled.class);
            ScheduledDefinition scheduledDefinition = new ScheduledDefinition();
            if (scheduled == null) continue;
            scheduledDefinition.setScheduled(scheduled);
            scheduledDefinition.setBeanInstance(beanInstance);
            this.scheduledDefinitions.add(scheduledDefinition);
        }
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        this.initAndRegisterTask();
        for (ScheduledDefinition scheduledDefinition : this.scheduledDefinitions) {
            CronTrigger eventTrigger;
            IScheduled iScheduledInstance;
            Scheduled scheduled = scheduledDefinition.getScheduled();
            IScheduledDecider scheduledDecider = (IScheduledDecider)this.beanFactory.getBean(scheduled.decider());
            if (!scheduledDecider.startUp(iScheduledInstance = scheduledDefinition.getBeanInstance(), scheduled)) continue;
            String expression = scheduled.expr();
            if (expression.matches("[0-9]+")) {
                long fixRate = Long.parseLong(expression);
                eventTrigger = new PeriodicTrigger(fixRate * 1000L);
            } else {
                eventTrigger = new CronTrigger(expression);
            }
            CronTrigger finalEventTrigger = eventTrigger;
            taskRegistrar.addTriggerTask((Runnable)iScheduledInstance, arg_0 -> ScheduleInitFactory.lambda$configureTasks$0((Trigger)finalEventTrigger, iScheduledInstance, arg_0));
        }
    }

    private static /* synthetic */ Date lambda$configureTasks$0(Trigger finalEventTrigger, IScheduled iScheduledInstance, TriggerContext triggerContext) {
        Date nextExecTime;
        iScheduledInstance.nextExecutionTime = nextExecTime = finalEventTrigger.nextExecutionTime(triggerContext);
        return nextExecTime;
    }
}

