/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.daemon.global;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import plus.jdk.daemon.annotation.Daemon;
import plus.jdk.daemon.config.DaemonConfig;
import plus.jdk.daemon.decider.IDaemonDecider;
import plus.jdk.daemon.model.DaemonDefinition;
import plus.jdk.daemon.model.IDaemon;

public class DaemonInitFactory {
    private static final Logger log = LoggerFactory.getLogger(DaemonInitFactory.class);
    private final BeanFactory beanFactory;
    private final ApplicationContext applicationContext;

    public DaemonInitFactory(BeanFactory beanFactory, ApplicationContext applicationContext, DaemonConfig properties) {
        this.beanFactory = beanFactory;
        this.applicationContext = applicationContext;
    }

    protected void initializationDefinition() {
        String[] beanNames;
        for (String beanName : beanNames = this.applicationContext.getBeanNamesForAnnotation(Daemon.class)) {
            IDaemon beanInstance = (IDaemon)this.applicationContext.getBean(beanName, IDaemon.class);
            Daemon daemon = (Daemon)this.applicationContext.findAnnotationOnBean(beanName, Daemon.class);
            DaemonDefinition daemonDefinition = new DaemonDefinition();
            daemonDefinition.setDaemon(daemon);
            daemonDefinition.setBeanInstance(beanInstance);
            assert (daemon != null);
            IDaemonDecider daemonDecider = (IDaemonDecider)this.beanFactory.getBean(daemon.decider());
            if (!daemonDecider.startUp()) continue;
            this.createDaemon(daemonDefinition);
        }
    }

    private void createDaemon(DaemonDefinition daemonDefinition) {
        IDaemon daemon = daemonDefinition.getBeanInstance();
        Daemon daemonComponent = daemonDefinition.getDaemon();
        for (int i = 0; i < daemonComponent.threadNum(); ++i) {
            Thread daemonThread = new Thread(() -> {
                while (true) {
                    try {
                        while (true) {
                            daemon.onBefore();
                            daemon.run();
                            daemon.onAfter();
                        }
                    }
                    catch (Error | Exception e) {
                        e.printStackTrace();
                        log.error("start daemon {} failed, message:{}", (Object)daemon.getClass().getName(), (Object)e.getMessage());
                        continue;
                    }
                    break;
                }
            });
            daemonThread.start();
        }
    }
}

