/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.broadcast.broadcaster;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.logging.LoggingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.jdk.broadcast.broadcaster.IBroadcaster;
import plus.jdk.broadcast.broadcaster.adapter.BroadcastMessageEncoder;
import plus.jdk.broadcast.broadcaster.model.BroadcastMessage;
import plus.jdk.broadcast.properties.BroadCastProperties;

public class UdpMessageBroadcaster
implements IBroadcaster {
    private static final Logger log = LoggerFactory.getLogger(UdpMessageBroadcaster.class);
    private final BroadCastProperties properties;
    private final EventLoopGroup group;
    private final Bootstrap bootstrap;
    private Channel channel;
    private Boolean started = false;

    public UdpMessageBroadcaster(final BroadCastProperties properties) {
        this.properties = properties;
        this.group = new NioEventLoopGroup();
        this.bootstrap = new Bootstrap();
        ((Bootstrap)this.bootstrap.group(this.group)).channel(NioDatagramChannel.class);
        this.bootstrap.option(ChannelOption.SO_BROADCAST, (Object)true);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new BroadcastMessageEncoder(properties)});
                pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(properties.getLogging()));
            }
        });
    }

    private void start() {
        this.started = true;
        this.channel = this.bootstrap.bind(this.properties.getBroadcastPort().intValue()).syncUninterruptibly().channel();
    }

    @Override
    public ChannelFuture publish(BroadcastMessage data) {
        if (!this.started.booleanValue()) {
            this.start();
        }
        return this.channel.writeAndFlush((Object)data);
    }

    public void shutdown() {
        this.group.shutdownGracefully();
    }
}

