/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.broadcast.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import plus.jdk.broadcast.broadcaster.UdpBroadcastMessageMonitor;
import plus.jdk.broadcast.broadcaster.UdpMessageBroadcaster;
import plus.jdk.broadcast.properties.BroadCastProperties;

@Configuration
@ConditionalOnProperty(prefix="plus.jdk.broadcast", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={BroadCastProperties.class})
public class BroadCastAutoConfiguration
implements DisposableBean,
WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(BroadCastAutoConfiguration.class);
    private final BroadCastProperties broadCastProperties;

    public BroadCastAutoConfiguration(BroadCastProperties broadCastProperties) {
        this.broadCastProperties = broadCastProperties;
    }

    @Bean
    public BroadCastProperties broadCastProperties() {
        return this.broadCastProperties;
    }

    @Bean
    public UdpMessageBroadcaster udpMessageBroadcaster() {
        return new UdpMessageBroadcaster(this.broadCastProperties);
    }

    @Bean
    public UdpBroadcastMessageMonitor udpMessageMonitor() {
        return new UdpBroadcastMessageMonitor(this.broadCastProperties);
    }

    public void destroy() {
    }
}

