/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.broadcast.broadcaster;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.jdk.broadcast.broadcaster.IMessageMonitor;
import plus.jdk.broadcast.broadcaster.adapter.BroadcastMessageDecoder;
import plus.jdk.broadcast.broadcaster.model.BroadcastMessage;
import plus.jdk.broadcast.common.IMessageProcessor;
import plus.jdk.broadcast.properties.BroadCastProperties;

public class UdpBroadcastMessageMonitor
implements IMessageMonitor {
    private static final Logger log = LoggerFactory.getLogger(UdpBroadcastMessageMonitor.class);
    private final BroadCastProperties properties;
    private final EventLoopGroup group;
    private final Bootstrap bootstrap;

    public UdpBroadcastMessageMonitor(BroadCastProperties properties) {
        this.properties = properties;
        this.group = new NioEventLoopGroup();
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(this.group);
        this.bootstrap.channel(NioDatagramChannel.class);
        this.bootstrap.option(ChannelOption.SO_BROADCAST, (Object)true);
        this.bootstrap.localAddress((SocketAddress)new InetSocketAddress(properties.getMonitorPort()));
        this.bootstrap.handler((ChannelHandler)new LoggingHandler(properties.getLogging()));
        log.info("========>>> broadcast server started, listen port: {} <<<========", (Object)properties.getMonitorPort());
    }

    @Override
    public void subscribe(final IMessageProcessor processor) {
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new BroadcastMessageDecoder(UdpBroadcastMessageMonitor.this.properties)});
                pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<BroadcastMessage>(){

                    protected void channelRead0(ChannelHandlerContext ctx, BroadcastMessage msg) {
                        processor.processMessage(ctx, msg);
                    }
                }});
            }
        });
        ChannelFuture channelFuture = this.bootstrap.bind();
        channelFuture.addListener(future -> {
            if (!future.isSuccess()) {
                future.cause().printStackTrace();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((EventLoopGroup)this.group).shutdownGracefully()));
    }

    public BroadCastProperties getProperties() {
        return this.properties;
    }
}

