/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.resources.service;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.access.expression.method.MethodSecurityExpressionOperations;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import plus.easydo.starter.oauth.core.model.CustomizeUsernamePasswordAuthenticationToken;

public class MySecurityExpressionRoot
extends SecurityExpressionRoot
implements MethodSecurityExpressionOperations {
    private static final String ALL = "ALL";
    private static final String ALL_PERMISSION = "*:*:*";
    private Object filterObject;
    private Object returnObject;
    private Object target;
    private Collection<? extends Serializable> permissions;
    private Object user;
    private OAuth2Request oAuth2Request;

    public MySecurityExpressionRoot(Authentication authentication) {
        super(authentication);
        if (authentication instanceof OAuth2Authentication) {
            OAuth2Authentication oAuth2Authentication = (OAuth2Authentication)authentication;
            Authentication userAuthentication = oAuth2Authentication.getUserAuthentication();
            this.oAuth2Request = oAuth2Authentication.getOAuth2Request();
            if (userAuthentication instanceof CustomizeUsernamePasswordAuthenticationToken) {
                CustomizeUsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = (CustomizeUsernamePasswordAuthenticationToken)userAuthentication;
                this.permissions = usernamePasswordAuthenticationToken.getPermissions();
                this.user = usernamePasswordAuthenticationToken.getPrincipal();
            }
        }
    }

    public final boolean hasPermission(Object code) {
        return this.hasAnyPermission(code);
    }

    public final boolean notHasPermission(Object code) {
        return !this.hasAnyPermission(code);
    }

    public final boolean hasAnyPermission(String[] code) {
        if (this.permissions.contains(ALL_PERMISSION)) {
            return true;
        }
        return this.hasAny(this.permissions, code);
    }

    public final boolean hasAnyPermission(Object ... objects) {
        if (this.permissions.contains(ALL_PERMISSION)) {
            return true;
        }
        return this.hasAny(this.permissions, objects);
    }

    public final boolean notHasAnyPermission(String[] code) {
        if (this.permissions.contains(ALL_PERMISSION)) {
            return true;
        }
        return !this.hasAny(this.permissions, code);
    }

    public final boolean hasScope(Object scope) {
        return this.hasAny(this.oAuth2Request.getScope(), scope);
    }

    public final boolean notHasScope(Object scope) {
        return !this.hasAny(this.oAuth2Request.getScope(), scope);
    }

    public final boolean hasAnyScope(Object ... scope) {
        return this.hasAny(this.oAuth2Request.getScope(), scope);
    }

    public final boolean hasAnyScope(String[] scope) {
        return this.hasAny((Collection<?>)this.oAuth2Request.getScope(), scope);
    }

    public final boolean notHasAnyScope(Object ... scope) {
        return !this.hasAny(this.oAuth2Request.getScope(), scope);
    }

    public final boolean hasClient(String clientId) {
        String client = this.oAuth2Request.getClientId();
        if (client != null && clientId != null) {
            return client.equals(clientId);
        }
        return false;
    }

    public final boolean notHasClient(String clientId) {
        String client = this.oAuth2Request.getClientId();
        if (client != null && clientId != null) {
            return !client.equals(clientId);
        }
        return true;
    }

    public final boolean hasResource(Object resource) {
        return this.hasAnyResource(resource);
    }

    public final boolean notHasResource(Object resource) {
        return !this.hasAnyResource(resource);
    }

    public final boolean hasAnyResource(Object ... resource) {
        return this.hasAny(this.oAuth2Request.getResourceIds(), resource);
    }

    public final boolean hasAnyResource(String[] resource) {
        return this.hasAny((Collection<?>)this.oAuth2Request.getResourceIds(), resource);
    }

    public final boolean notHasAnyResource(Object ... resource) {
        return !this.hasAny(this.oAuth2Request.getResourceIds(), resource);
    }

    private boolean hasAny(Collection<?> var1, Object ... var2) {
        if (var1 != null) {
            for (Object o : var2) {
                if (!var1.contains(o)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAny(Collection<?> var1, String[] var2) {
        AtomicBoolean hasAny = new AtomicBoolean(false);
        if (var1 != null) {
            for (String code : var2) {
                if (!var1.contains(code)) continue;
                hasAny.set(true);
                break;
            }
        }
        return hasAny.get();
    }

    public final boolean read() {
        return this.hasScope("read");
    }

    public final boolean write() {
        return this.hasScope("write");
    }

    public final boolean create() {
        return this.hasScope("create");
    }

    public final boolean delete() {
        return this.hasScope("delete");
    }

    public final boolean all() {
        return this.hasScope(ALL);
    }

    public Object getFilterObject() {
        return this.filterObject;
    }

    public void setFilterObject(Object o) {
        this.filterObject = o;
    }

    public Object getReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(Object o) {
        this.returnObject = o;
    }

    public Object getThis() {
        return this.target;
    }

    public void setThis(Object target) {
        this.target = target;
    }

    public Collection<? extends Serializable> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<? extends Serializable> permissions) {
        this.permissions = permissions;
    }

    public Object getUser() {
        return this.user;
    }

    public void setUser(Object user) {
        this.user = user;
    }
}

