/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.resources.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.util.StringUtils;
import plus.easydo.starter.oauth.core.model.CustomizeUserDetails;
import plus.easydo.starter.oauth.core.model.CustomizeUsernamePasswordAuthenticationToken;

public class CustomizeDefaultUserAuthenticationConverter
extends DefaultUserAuthenticationConverter
implements UserAuthenticationConverter {
    private static final String ALL = "ALL";
    private static final String USER = "user";
    private static final String PERMISSIONS = "permissions";
    private static final String AUTHORITIES = "authorities";

    public Authentication extractAuthentication(Map<String, ?> map) {
        Object all;
        if (map.containsKey(ALL) && (all = map.get(ALL)) instanceof Authentication) {
            CustomizeUserDetails customizeUserDetails;
            Collection permissions;
            Authentication authentication = (Authentication)all;
            Object principal = authentication.getPrincipal();
            CustomizeUsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new CustomizeUsernamePasswordAuthenticationToken(principal, (Object)"N/A", authentication.getAuthorities());
            if (principal instanceof CustomizeUserDetails && (permissions = (customizeUserDetails = (CustomizeUserDetails)principal).getPermissions()) != null) {
                usernamePasswordAuthenticationToken.setPermissions(permissions);
            }
            return usernamePasswordAuthenticationToken;
        }
        if (map.containsKey(USER) && map.containsKey(PERMISSIONS)) {
            Object user = map.get(USER);
            Object permissions = map.get(PERMISSIONS);
            Collection<? extends GrantedAuthority> authorities = this.getAuthorities1(map);
            CustomizeUsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new CustomizeUsernamePasswordAuthenticationToken(user, (Object)"N/A", authorities);
            if (permissions instanceof Collection) {
                usernamePasswordAuthenticationToken.setPermissions((Collection)permissions);
            }
            return usernamePasswordAuthenticationToken;
        }
        return super.extractAuthentication(map);
    }

    private Collection<? extends GrantedAuthority> getAuthorities1(Map<String, ?> map) {
        if (!map.containsKey(AUTHORITIES)) {
            return new HashSet<GrantedAuthority>(){};
        }
        Object authorities = map.get(AUTHORITIES);
        if (authorities instanceof String) {
            return AuthorityUtils.commaSeparatedStringToAuthorityList((String)((String)authorities));
        }
        if (authorities instanceof Collection) {
            return AuthorityUtils.commaSeparatedStringToAuthorityList((String)StringUtils.collectionToCommaDelimitedString((Collection)((Collection)authorities)));
        }
        throw new IllegalArgumentException("Authorities must be a string or a collection");
    }
}

