/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.resources.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import org.springframework.web.util.HtmlUtils;
import plus.easydo.starter.oauth.core.exception.CustomizeOAuth2Exception;

public class CustomizeOauth2ExceptionSerializer
extends StdSerializer<CustomizeOAuth2Exception> {
    protected CustomizeOauth2ExceptionSerializer() {
        super(CustomizeOAuth2Exception.class);
    }

    public void serialize(CustomizeOAuth2Exception e, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        generator.writeStartObject();
        generator.writeObjectField("status", (Object)e.getHttpErrorCode());
        String message = e.getMessage();
        if (message != null) {
            message = HtmlUtils.htmlEscape((String)message);
        }
        generator.writeStringField("message", message);
        if (e.getAdditionalInformation() != null) {
            for (Map.Entry entry : e.getAdditionalInformation().entrySet()) {
                String key = (String)entry.getKey();
                String add = (String)entry.getValue();
                generator.writeStringField(key, add);
            }
        }
        generator.writeEndObject();
    }
}

