/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.resources.configure;

import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import plus.easydo.starter.oauth.resources.configure.CustomizeGlobalMethodSecurityConfiguration;
import plus.easydo.starter.oauth.resources.configure.ResourcesBeanConfig;
import plus.easydo.starter.oauth.resources.handler.CustomizeAccessDeniedHandler;
import plus.easydo.starter.oauth.resources.web.CustomizeAuthenticationEntryPoint;

@Configuration
@EnableResourceServer
@Import(value={CustomizeGlobalMethodSecurityConfiguration.class, ResourcesBeanConfig.class})
@EnableConfigurationProperties(value={ResourceServerProperties.class})
public class ResourcesServerAutoConfiguration
extends ResourceServerConfigurerAdapter {
    @Resource
    ResourcesBeanConfig resourcesBeanConfig;
    @Value(value="${security.oauth2.whitelist}")
    private List<String> whiteList;

    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
        resources.tokenServices(this.resourcesBeanConfig.getResourceServerTokenServices()).resourceId(this.resourcesBeanConfig.properties().getResourceId()).authenticationEntryPoint((AuthenticationEntryPoint)new CustomizeAuthenticationEntryPoint()).accessDeniedHandler((AccessDeniedHandler)new CustomizeAccessDeniedHandler());
        super.configure(resources);
    }

    public void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/actuator/**"})).permitAll().antMatchers((String[])this.whiteList.stream().distinct().toArray(String[]::new))).permitAll().antMatchers(HttpMethod.GET, new String[]{"/static/**", "/*.html", "/**/*.html", "/**/*.css", "/**/*.js"})).permitAll().antMatchers((String[])this.resourcesBeanConfig.getAuthIgnoreConfig().getIgnoreUrls().stream().distinct().toArray(String[]::new))).permitAll().anyRequest()).authenticated();
    }
}

