/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.resources.configure;

import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.security.oauth2.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import plus.easydo.starter.oauth.core.config.SecurityBeanConfig;
import plus.easydo.starter.oauth.resources.configure.AuthIgnoreConfig;
import plus.easydo.starter.oauth.resources.service.CustomizeDefaultUserAuthenticationConverter;

@Configuration(value="resourcesBeanConfig")
@EnableConfigurationProperties(value={OAuth2ClientProperties.class})
public class ResourcesBeanConfig
implements SecurityBeanConfig<ResourceServerProperties> {
    @Resource
    OAuth2ClientProperties oAuth2ClientProperties;
    @Resource
    ResourceServerProperties resourceServerProperties;
    @Resource
    AuthIgnoreConfig authIgnoreConfig;
    @Resource
    private AccessTokenConverter accessTokenConverter;

    public ResourceServerProperties properties() {
        return this.resourceServerProperties;
    }

    public ClientDetailsService getClientDetailsService() {
        return null;
    }

    public AuthorizationServerTokenServices getAuthorizationServerTokenServices() {
        return null;
    }

    @Bean
    public AccessTokenConverter accessTokenConverter() {
        DefaultAccessTokenConverter defaultAccessTokenConverter = new DefaultAccessTokenConverter();
        CustomizeDefaultUserAuthenticationConverter myDefaultUserAuthenticationConverter = new CustomizeDefaultUserAuthenticationConverter();
        defaultAccessTokenConverter.setUserTokenConverter((UserAuthenticationConverter)myDefaultUserAuthenticationConverter);
        return defaultAccessTokenConverter;
    }

    public AuthIgnoreConfig getAuthIgnoreConfig() {
        return this.authIgnoreConfig;
    }

    public ResourceServerTokenServices getResourceServerTokenServices() {
        RemoteTokenServices tokenServices = new RemoteTokenServices();
        tokenServices.setCheckTokenEndpointUrl(this.resourceServerProperties.getTokenInfoUri());
        tokenServices.setClientId(this.oAuth2ClientProperties.getClientId());
        tokenServices.setClientSecret(this.oAuth2ClientProperties.getClientSecret());
        tokenServices.setAccessTokenConverter(this.accessTokenConverter);
        return tokenServices;
    }
}

