/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.resources.configure;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import plus.easydo.starter.oauth.resources.anotation.IgnoreThePermissions;

@Configuration
public class AuthIgnoreConfig
implements InitializingBean {
    private static final Pattern PATTERN = Pattern.compile("\\{(.*?)\\}");
    private static final String ASTERISK = "*";
    protected final Logger log = LoggerFactory.getLogger(AuthIgnoreConfig.class);
    @Resource
    private ApplicationContext applicationContext;
    private List<String> ignoreUrls = new ArrayList<String>();

    public void afterPropertiesSet() {
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)this.applicationContext.getBean(RequestMappingHandlerMapping.class);
        Map map = mapping.getHandlerMethods();
        map.keySet().forEach(mappingInfo -> {
            HandlerMethod handlerMethod = (HandlerMethod)map.get(mappingInfo);
            IgnoreThePermissions method = (IgnoreThePermissions)AnnotationUtils.findAnnotation((Method)handlerMethod.getMethod(), IgnoreThePermissions.class);
            Optional.ofNullable(method).ifPresent(authIgnore -> mappingInfo.getPatternsCondition().getPatterns().forEach(url -> this.ignoreUrls.add(ReUtil.replaceAll((CharSequence)url, (Pattern)PATTERN, (String)ASTERISK))));
        });
        Optional.of(this.applicationContext.getBeansWithAnnotation(IgnoreThePermissions.class)).ifPresent(stringObjectMap -> stringObjectMap.values().forEach(object -> Arrays.asList(object.getClass().getInterfaces()[0].getDeclaredMethods()).forEach(method -> {
            List<Annotation> annotations = Arrays.asList(method.getAnnotation(RequestMapping.class), method.getAnnotation(PostMapping.class), method.getAnnotation(GetMapping.class));
            annotations.forEach(annotation -> {
                if (ObjectUtil.isNotEmpty((Object)annotation)) {
                    try {
                        Field field = Proxy.getInvocationHandler(annotation).getClass().getDeclaredField("memberValues");
                        field.setAccessible(true);
                        Map valueMap = (Map)field.get(Proxy.getInvocationHandler(annotation));
                        String[] string = (String[])valueMap.get("value");
                        this.ignoreUrls.add("/".concat(ReUtil.replaceAll((CharSequence)string[0], (Pattern)PATTERN, (String)ASTERISK)));
                    }
                    catch (Exception e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        })));
    }

    public List<String> getIgnoreUrls() {
        return this.ignoreUrls;
    }

    public void setIgnoreUrls(List<String> ignoreUrls) {
        this.ignoreUrls = ignoreUrls;
    }
}

