/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.resources.aspect;

import cn.hutool.core.lang.Validator;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Component;
import plus.easydo.core.exception.HasPermissionException;
import plus.easydo.starter.oauth.core.utils.Oauth2Utils;
import plus.easydo.starter.oauth.resources.anotation.CustomizePreAuthorize;
import plus.easydo.starter.oauth.resources.service.MySecurityExpressionRoot;

@Aspect
@Component
public class CustomizePreAuthorizeAspect {
    private static final Integer ARRAY_EMPTY = 0;

    @Around(value="@annotation(plus.easydo.starter.oauth.resources.anotation.CustomizePreAuthorize)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        CustomizePreAuthorize annotation = method.getAnnotation(CustomizePreAuthorize.class);
        if (annotation == null) {
            return point.proceed();
        }
        OAuth2Authentication authentication = Oauth2Utils.getOauth2Authentication();
        MySecurityExpressionRoot expressionRoot = new MySecurityExpressionRoot((Authentication)authentication);
        if (ARRAY_EMPTY < annotation.hasPermission().length) {
            if (!expressionRoot.hasAnyPermission(annotation.hasPermission())) {
                throw new HasPermissionException();
            }
        } else if (ARRAY_EMPTY < annotation.notHasPermission().length) {
            if (expressionRoot.hasAnyPermission(annotation.notHasPermission())) {
                throw new HasPermissionException();
            }
        } else if (ARRAY_EMPTY < annotation.hasScope().length) {
            if (!expressionRoot.hasAnyScope(annotation.hasScope())) {
                throw new HasPermissionException();
            }
        } else if (ARRAY_EMPTY < annotation.notHasScope().length) {
            if (expressionRoot.hasAnyScope(annotation.notHasScope())) {
                throw new HasPermissionException();
            }
        } else if (Validator.isNotEmpty((Object)annotation.hasClient())) {
            if (!expressionRoot.hasClient(annotation.hasClient())) {
                throw new HasPermissionException();
            }
        } else if (Validator.isNotEmpty((Object)annotation.notHasClient())) {
            if (expressionRoot.hasClient(annotation.notHasClient())) {
                throw new HasPermissionException();
            }
        } else if (ARRAY_EMPTY < annotation.hasResource().length) {
            if (!expressionRoot.hasAnyResource(annotation.hasResource())) {
                throw new HasPermissionException();
            }
        } else if (ARRAY_EMPTY < annotation.notHasResource().length) {
            if (expressionRoot.hasAnyResource(annotation.notHasResource())) {
                throw new HasPermissionException();
            }
        } else if (annotation.read()) {
            if (!expressionRoot.read()) {
                throw new HasPermissionException();
            }
        } else if (annotation.write()) {
            if (!expressionRoot.write()) {
                throw new HasPermissionException();
            }
        } else if (annotation.create()) {
            if (!expressionRoot.create()) {
                throw new HasPermissionException();
            }
        } else if (annotation.delete()) {
            if (!expressionRoot.delete()) {
                throw new HasPermissionException();
            }
        } else if (annotation.all()) {
            if (expressionRoot.all()) {
                return point.proceed();
            }
            throw new HasPermissionException();
        }
        return point.proceed();
    }
}

