package plus.easydo.starter.oauth.resources.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.springframework.web.util.HtmlUtils;
import plus.easydo.starter.oauth.core.exception.CustomizeOAuth2Exception;

import java.io.IOException;
import java.util.Map;

/**
 * 序列化异常类
 * @author yuzhanfeng
 */
public class CustomizeOauth2ExceptionSerializer extends StdSerializer<CustomizeOAuth2Exception> {

    protected CustomizeOauth2ExceptionSerializer() {
        super(CustomizeOAuth2Exception.class);
    }

    @Override
    public void serialize(CustomizeOAuth2Exception e, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        generator.writeStartObject();
        generator.writeObjectField("status", e.getHttpErrorCode());
        String message = e.getMessage();
        if (message != null) {
            message = HtmlUtils.htmlEscape(message);
        }
        generator.writeStringField("message", message);
        if (e.getAdditionalInformation()!=null) {
            for (Map.Entry<String, String> entry : e.getAdditionalInformation().entrySet()) {
                String key = entry.getKey();
                String add = entry.getValue();
                generator.writeStringField(key, add);
            }
        }
        generator.writeEndObject();
    }
}
