package plus.easydo.starter.oauth.resources.configure;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import plus.easydo.starter.oauth.resources.handler.CustomizeAccessDeniedHandler;
import plus.easydo.starter.oauth.resources.web.CustomizeAuthenticationEntryPoint;

import javax.annotation.Resource;
import java.util.List;


/**
 * 自定义资源验证
 *
 * @author yuzhanfeng
 */
@Configuration
@EnableResourceServer
@Import({CustomizeGlobalMethodSecurityConfiguration.class, ResourcesBeanConfig.class})
@EnableConfigurationProperties({ResourceServerProperties.class})
public class ResourcesServerAutoConfiguration extends ResourceServerConfigurerAdapter {

    @Resource
    ResourcesBeanConfig resourcesBeanConfig;

    @Value("${security.oauth2.whitelist}")
    private List<String> whiteList;

    @Override
    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
        resources
                .tokenServices(resourcesBeanConfig.getResourceServerTokenServices())
                .resourceId(resourcesBeanConfig.properties().getResourceId())
                /*认证异常处理类*/
                .authenticationEntryPoint(new CustomizeAuthenticationEntryPoint())
                /*权限异常处理类*/
                .accessDeniedHandler(new CustomizeAccessDeniedHandler());
        super.configure(resources);
    }

    @Override
    public void configure(HttpSecurity http) throws Exception {
        http
                /*关闭csrf 不使用session*/
                .csrf().disable()
                .authorizeRequests()
                /*放行健康实例监控相关url*/
                .antMatchers("/actuator/**").permitAll()
                /*放行白名单*/
                .antMatchers(whiteList.stream().distinct().toArray(String[]::new)).permitAll()
                /*放行静态资源*/
                .antMatchers(
                        HttpMethod.GET,
                        "/static/**",
                        "/*.html",
                        "/**/*.html",
                        "/**/*.css",
                        "/**/*.js"
                ).permitAll()
                /*放行所有具有IgnoreThePermissions注解的端点映射*/
                .antMatchers(resourcesBeanConfig.getAuthIgnoreConfig().getIgnoreUrls().stream().distinct().toArray(String[]::new)).permitAll()
                // 除上面外的所有请求全部需要鉴权认证
                .anyRequest().authenticated();
    }
}
