package plus.easydo.starter.oauth.resources.configure;

import org.springframework.boot.autoconfigure.security.oauth2.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import plus.easydo.starter.oauth.core.config.SecurityBeanConfig;
import plus.easydo.starter.oauth.resources.service.CustomizeDefaultUserAuthenticationConverter;

import javax.annotation.Resource;

/**
 * @author laoyu
 * @version 1.0
 */
@Configuration("resourcesBeanConfig")
@EnableConfigurationProperties({OAuth2ClientProperties.class})
public class ResourcesBeanConfig implements SecurityBeanConfig<ResourceServerProperties> {

    @Resource
    OAuth2ClientProperties oAuth2ClientProperties;
    @Resource
    ResourceServerProperties resourceServerProperties;
    @Resource
    AuthIgnoreConfig authIgnoreConfig;
    @Resource
    private AccessTokenConverter accessTokenConverter;

    @Override
    public ResourceServerProperties properties() {
        return resourceServerProperties;
    }

    @Override
    public ClientDetailsService getClientDetailsService() {
        return null;
    }

    @Override
    public AuthorizationServerTokenServices getAuthorizationServerTokenServices() {
        return null;
    }

    @Bean
    public AccessTokenConverter accessTokenConverter() {
        DefaultAccessTokenConverter defaultAccessTokenConverter = new DefaultAccessTokenConverter();
        CustomizeDefaultUserAuthenticationConverter myDefaultUserAuthenticationConverter =
                new CustomizeDefaultUserAuthenticationConverter();
        defaultAccessTokenConverter.setUserTokenConverter(myDefaultUserAuthenticationConverter);
        return defaultAccessTokenConverter;
    }


    public AuthIgnoreConfig getAuthIgnoreConfig() {
        return authIgnoreConfig;
    }

    public ResourceServerTokenServices getResourceServerTokenServices() {
        RemoteTokenServices tokenServices = new RemoteTokenServices();
        /*设置校验token远程地址*/
        tokenServices.setCheckTokenEndpointUrl(resourceServerProperties.getTokenInfoUri());
        /*不配置这两个信息校验token会报错*/
        tokenServices.setClientId(oAuth2ClientProperties.getClientId());
        tokenServices.setClientSecret(oAuth2ClientProperties.getClientSecret());
        tokenServices.setAccessTokenConverter(accessTokenConverter);
        return tokenServices;
    }

}
