package plus.easydo.starter.oauth.resources.configure;

import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;

/**
 * GlobalMethodSecurityConfiguration拓展配置类 注入拓展安全表达式
 * @author yuzhanfeng
 */
@Configuration
@EnableGlobalMethodSecurity(prePostEnabled = true)
public class CustomizeGlobalMethodSecurityConfiguration extends GlobalMethodSecurityConfiguration {

    @Override
    protected MethodSecurityExpressionHandler createExpressionHandler() {
        return new CustomizeDefaultMethodSecurityExpressionHandler();
    }
}
