package plus.easydo.starter.oauth.resources.configure;

import org.aopalliance.intercept.MethodInvocation;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionOperations;
import org.springframework.security.core.Authentication;
import plus.easydo.starter.oauth.resources.service.MySecurityExpressionRoot;

/**
 * 拓展表达式处理器
 * @author yuzhanfeng
 */
public class CustomizeDefaultMethodSecurityExpressionHandler extends DefaultMethodSecurityExpressionHandler {

    /**
     * 注入自定义表达式
     * @param authentication authentication
     * @param invocation invocation
     * @return MySecurityExpressionRoot
     */
    @Override
    protected MethodSecurityExpressionOperations createSecurityExpressionRoot(Authentication authentication, MethodInvocation invocation) {
        MySecurityExpressionRoot root = new MySecurityExpressionRoot(authentication);
        root.setThis(invocation.getThis());
        root.setPermissionEvaluator(this.getPermissionEvaluator());
        root.setTrustResolver(this.getTrustResolver());
        root.setRoleHierarchy(this.getRoleHierarchy());
        root.setDefaultRolePrefix(this.getDefaultRolePrefix());
        return root;
    }
}
