package plus.easydo.starter.oauth.resources.configure;

import cn.hutool.core.text.StrPool;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import plus.easydo.starter.oauth.resources.anotation.IgnoreThePermissions;

import javax.annotation.Resource;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;


/**
 * 实现InitializingBean接口后,该类初始化的时候会调用afterPropertiesSet方法 遍历出所有具有AuthIgnore.class注解的方法
 *
 * @author yuzhanfeng
 */
@Configuration
public class AuthIgnoreConfig implements InitializingBean {

    private static final Pattern PATTERN = Pattern.compile("\\{(.*?)\\}");
    private static final String ASTERISK = "*";
    protected final Logger log = LoggerFactory.getLogger(AuthIgnoreConfig.class);
    @Resource
    private ApplicationContext applicationContext;
    private List<String> ignoreUrls = new ArrayList<>();

    @Override
    public void afterPropertiesSet() {
        RequestMappingHandlerMapping mapping = applicationContext.getBean(RequestMappingHandlerMapping.class);
        Map<RequestMappingInfo, HandlerMethod> map = mapping.getHandlerMethods();
        map.keySet().forEach(mappingInfo -> {
            HandlerMethod handlerMethod = map.get(mappingInfo);
            IgnoreThePermissions method = AnnotationUtils.findAnnotation(handlerMethod.getMethod(), IgnoreThePermissions.class);
            Optional.ofNullable(method)
                    .ifPresent(authIgnore -> mappingInfo
                            .getPatternsCondition()
                            .getPatterns()
                            .forEach(url -> ignoreUrls.add(ReUtil.replaceAll(url, PATTERN, ASTERISK))));
        });
        Optional.of(applicationContext.getBeansWithAnnotation(IgnoreThePermissions.class))
                .ifPresent(stringObjectMap -> stringObjectMap.values()
                        .forEach(object -> Arrays.asList(object.getClass().getInterfaces()[0].getDeclaredMethods()).forEach(method -> {
                            List<Annotation> annotations = Arrays.asList(method.getAnnotation(RequestMapping.class), method.getAnnotation(PostMapping.class),
                                    method.getAnnotation(GetMapping.class));
                            annotations.forEach(annotation -> {
                                if (ObjectUtil.isNotEmpty(annotation)) {
                                    try {
                                        Field field = Proxy.getInvocationHandler(annotation).getClass().getDeclaredField("memberValues");
                                        field.setAccessible(true);
                                        Map<String, Object> valueMap = (Map<String, Object>) field.get(Proxy.getInvocationHandler(annotation));
                                        String[] string = (String[]) valueMap.get("value");
                                        ignoreUrls.add(StrPool.SLASH.concat(ReUtil.replaceAll(string[0], PATTERN, ASTERISK)));
                                    } catch (Exception e) {
                                        log.error(e.getMessage(), e);
                                    }
                                }
                            });
                        })));
    }

    public List<String> getIgnoreUrls() {
        return ignoreUrls;
    }

    public void setIgnoreUrls(List<String> ignoreUrls) {
        this.ignoreUrls = ignoreUrls;
    }
}
