package plus.easydo.starter.oauth.resources.aspect;

import cn.hutool.core.lang.Validator;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import plus.easydo.core.exception.HasPermissionException;
import plus.easydo.starter.oauth.core.utils.Oauth2Utils;
import plus.easydo.starter.oauth.resources.anotation.CustomizePreAuthorize;
import plus.easydo.starter.oauth.resources.service.MySecurityExpressionRoot;

import java.lang.reflect.Method;

/**
 * 自定义权限实现
 *
 * @author ruoyi
 */
@Aspect
@Component
public class CustomizePreAuthorizeAspect {

    /**
     * 数组为0时
     */
    private static final Integer ARRAY_EMPTY = 0;

    /**
     * @param point  切点
     * @return 结果
     * @throws Throwable HasPermissionException
     */
    @Around("@annotation(plus.easydo.starter.oauth.resources.anotation.CustomizePreAuthorize)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature) signature;
        Method method = methodSignature.getMethod();
        CustomizePreAuthorize annotation = method.getAnnotation(CustomizePreAuthorize.class);
        if (annotation == null) {
            return point.proceed();
        }
        Authentication authentication = Oauth2Utils.getOauth2Authentication();
        MySecurityExpressionRoot expressionRoot = new MySecurityExpressionRoot(authentication);
        if (ARRAY_EMPTY < annotation.hasPermission().length) {
            if (!expressionRoot.hasAnyPermission(annotation.hasPermission())) {
                throw new HasPermissionException();
            }
        } else if (ARRAY_EMPTY < annotation.notHasPermission().length) {
            if (expressionRoot.hasAnyPermission(annotation.notHasPermission())) {
                throw new HasPermissionException();
            }
        } else if (ARRAY_EMPTY < annotation.hasScope().length) {
            if (!expressionRoot.hasAnyScope(annotation.hasScope())) {
                throw new HasPermissionException();
            }
        } else if (ARRAY_EMPTY < annotation.notHasScope().length) {
            if (expressionRoot.hasAnyScope(annotation.notHasScope())) {
                throw new HasPermissionException();
            }
        } else if (Validator.isNotEmpty(annotation.hasClient())) {
            if (!expressionRoot.hasClient(annotation.hasClient())) {
                throw new HasPermissionException();
            }
        } else if (Validator.isNotEmpty(annotation.notHasClient())) {
            if (expressionRoot.hasClient(annotation.notHasClient())) {
                throw new HasPermissionException();
            }
        } else if (ARRAY_EMPTY < annotation.hasResource().length) {
            if (!expressionRoot.hasAnyResource(annotation.hasResource())) {
                throw new HasPermissionException();
            }
        } else if (ARRAY_EMPTY < annotation.notHasResource().length) {
            if (expressionRoot.hasAnyResource(annotation.notHasResource())) {
                throw new HasPermissionException();
            }
        } else if (annotation.read()) {
            if (!expressionRoot.read()) {
                throw new HasPermissionException();
            }
        } else if (annotation.write()) {
            if (!expressionRoot.write()) {
                throw new HasPermissionException();
            }
        } else if (annotation.create()) {
            if (!expressionRoot.create()) {
                throw new HasPermissionException();
            }
        } else if (annotation.delete()) {
            if (!expressionRoot.delete()) {
                throw new HasPermissionException();
            }
        } else if (annotation.all()) {
            if (expressionRoot.all()) {
                return point.proceed();
            }
            throw new HasPermissionException();
        }
        return point.proceed();
    }


}
