package plus.easydo.starter.oauth.resources.anotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 自定义PreAuthorize注解 基于自定义权限校验表达式的进一步强拓展
 * @author yuzhanfeng
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface CustomizePreAuthorize {

    /**具有权限字段则通过*/
    String[] hasPermission() default {};
    /**不具有指定权限字段则通过*/
    String[] notHasPermission() default {};
    /**具有特定scpo则通过*/
    String[] hasScope() default {};
    /**不具有指定scpo则通过*/
    String[] notHasScope() default {};
    /**指定的客户端才能访问*/
    String hasClient() default "";
    /**不是指定的客户端才能访问*/
    String notHasClient() default "";
    /**指定的资源服务才能访问*/
    String[] hasResource() default {};
    /**不是指定的资源服务才能访问*/
    String[] notHasResource() default {};
    /**scope具有写权限*/
    boolean read() default false;
    /**scope具有读取权限*/
    boolean write() default false;
    /**scope具有创建权限*/
    boolean create() default false;
    /**scope具有删除权限*/
    boolean delete() default false;
    /**scope具有ALL权限*/
    boolean all() default false;

}
