/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.oauth.core.utils;

import cn.hutool.core.bean.BeanUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import plus.easydo.starter.oauth.core.model.CustomizeUsernamePasswordAuthenticationToken;

public class Oauth2Utils {
    private static final String ADMIN = "admin";

    private Oauth2Utils() {
    }

    public static Map<String, Object> getUserInfo() {
        Object user = Oauth2Utils.getOauth2Authentication().getPrincipal();
        if (user instanceof Map) {
            return (Map)user;
        }
        return BeanUtil.beanToMap((Object)user);
    }

    public static String getUserName() {
        Map<String, Object> userMap = Oauth2Utils.getUserInfo();
        return (String)userMap.get("username");
    }

    public static Long getUserIdLong() {
        Map<String, Object> userMap = Oauth2Utils.getUserInfo();
        Object id = userMap.get("id");
        if (id instanceof Integer) {
            return Long.parseLong(id.toString());
        }
        if (id instanceof Long) {
            return (Long)id;
        }
        if (id instanceof String) {
            return Long.parseLong((String)id);
        }
        return null;
    }

    public static String getUserIdString() {
        Map<String, Object> userMap = Oauth2Utils.getUserInfo();
        Object id = userMap.get("id");
        return String.valueOf(id);
    }

    public static String getTenantId() {
        Map<String, Object> userMap = Oauth2Utils.getUserInfo();
        return (String)userMap.get("tenantId");
    }

    public static Integer getUserIdInteger() {
        Map<String, Object> userMap = Oauth2Utils.getUserInfo();
        Object id = userMap.get("id");
        if (id instanceof Integer) {
            return (Integer)id;
        }
        if (id instanceof Long) {
            return ((Long)id).intValue();
        }
        if (id instanceof String) {
            return Integer.parseInt((String)id);
        }
        return null;
    }

    public static Object getUserId() {
        Map<String, Object> userMap = Oauth2Utils.getUserInfo();
        return userMap.get("id");
    }

    public static Object getUserValue(String key) {
        Map<String, Object> map = Oauth2Utils.getUserInfo();
        return map.get(key);
    }

    public static Set<String> getRoles() {
        return Oauth2Utils.getOauth2Authentication().getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
    }

    public static Collection<?> getPermissions() {
        return Oauth2Utils.getUserAuthentication().getPermissions();
    }

    public static String getClientId() {
        return Oauth2Utils.getOauth2Request().getClientId();
    }

    public static String getTokenValue() {
        return Oauth2Utils.getDetails().getTokenValue();
    }

    public static String getTokenType() {
        return Oauth2Utils.getDetails().getTokenType();
    }

    public static Set<String> getResourceIds() {
        return Oauth2Utils.getOauth2Request().getResourceIds();
    }

    public static Set<String> getScope() {
        return Oauth2Utils.getOauth2Request().getScope();
    }

    public static String getRedirectUri() {
        return Oauth2Utils.getOauth2Request().getRedirectUri();
    }

    public static OAuth2AuthenticationDetails getDetails() {
        return (OAuth2AuthenticationDetails)Oauth2Utils.getOauth2Authentication().getDetails();
    }

    public static OAuth2Authentication getOauth2Authentication() {
        return (OAuth2Authentication)SecurityContextHolder.getContext().getAuthentication();
    }

    public static CustomizeUsernamePasswordAuthenticationToken getUserAuthentication() {
        return (CustomizeUsernamePasswordAuthenticationToken)Oauth2Utils.getOauth2Authentication().getUserAuthentication();
    }

    public static OAuth2Request getOauth2Request() {
        return Oauth2Utils.getOauth2Authentication().getOAuth2Request();
    }

    public static boolean isAdmin(Long userId) {
        return userId != null && 1L == userId;
    }

    public static boolean isAdmin() {
        return Oauth2Utils.getRoles().contains(ADMIN);
    }

    public static String encryptPassword(String password) {
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        return passwordEncoder.encode((CharSequence)password);
    }

    public static boolean matchesPassword(String rawPassword, String encodedPassword) {
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        return passwordEncoder.matches((CharSequence)rawPassword, encodedPassword);
    }
}

