package plus.easydo.starter.oauth.core.utils;

import cn.hutool.core.bean.BeanUtil;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import plus.easydo.starter.oauth.core.model.CustomizeUsernamePasswordAuthenticationToken;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author yuzhanfeng
 */
public class Oauth2Utils {

    private static final String ADMIN = "admin";

    private Oauth2Utils() {
    }

    public static Map<String, Object> getUserInfo() {
        Object user = getOauth2Authentication().getPrincipal();
        if (user instanceof Map){
            return (Map<String, Object>) user;
        }
        return BeanUtil.beanToMap(user);
    }

    public static String getUserName() {
        Map<String, Object> userMap = getUserInfo();
        return (String) userMap.get("username");
    }

    public static Long getUserIdLong() {
        Map<String, Object> userMap = getUserInfo();
        Object id = userMap.get("id");
        if (id instanceof Integer) {
            return Long.parseLong(id.toString());
        } else if (id instanceof Long) {
            return (Long) id;
        } else if (id instanceof String) {
            return Long.parseLong((String) id);
        } else {
            return null;
        }
    }

    public static String getUserIdString() {
        Map<String, Object> userMap = getUserInfo();
        Object id = userMap.get("id");
        return String.valueOf(id);
    }
    public static String getTenantId() {
        Map<String, Object> userMap = getUserInfo();
        return (String) userMap.get("tenantId");
    }

    public static Integer getUserIdInteger() {
        Map<String, Object> userMap = getUserInfo();
        Object id = userMap.get("id");
        if (id instanceof Integer) {
            return (Integer) id;
        } else if (id instanceof Long) {
            return ((Long) id).intValue();
        } else if (id instanceof String) {
            return Integer.parseInt((String) id);
        } else {
            return null;
        }
    }

    public static Object getUserId() {
        Map<String, Object> userMap = getUserInfo();
        return userMap.get("id");
    }

    public static Object getUserValue(String key) {
        Map<String, Object> map = getUserInfo();
        return map.get(key);
    }

    public static Set<String> getRoles() {
        return getOauth2Authentication().getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
    }

    public static Collection<?> getPermissions() {
        return getUserAuthentication().getPermissions();
    }

    public static String getClientId() {
        return getOauth2Request().getClientId();
    }

    public static String getTokenValue() {
        return getDetails().getTokenValue();
    }

    public static String getTokenType() {
        return getDetails().getTokenType();
    }

    public static Set<String> getResourceIds() {
        return getOauth2Request().getResourceIds();
    }

    public static Set<String> getScope() {
        return getOauth2Request().getScope();
    }

    public static String getRedirectUri() {
        return getOauth2Request().getRedirectUri();
    }

    public static OAuth2AuthenticationDetails getDetails() {
        return (OAuth2AuthenticationDetails) getOauth2Authentication().getDetails();
    }

    public static OAuth2Authentication getOauth2Authentication() {
        return (OAuth2Authentication) SecurityContextHolder.getContext().getAuthentication();
    }

    public static CustomizeUsernamePasswordAuthenticationToken getUserAuthentication() {
        return (CustomizeUsernamePasswordAuthenticationToken) getOauth2Authentication().getUserAuthentication();
    }

    public static OAuth2Request getOauth2Request() {
        return getOauth2Authentication().getOAuth2Request();
    }

    /**
     * 是否为管理员
     *
     * @param userId 用户ID
     * @return 结果
     */
    public static boolean isAdmin(Long userId) {
        return userId != null && 1L == userId;
    }

    /**
     * 是否为管理员
     *
     * @return 结果
     */
    public static boolean isAdmin() {
        return getRoles().contains(ADMIN);
    }

    /**
     * 生成BCryptPasswordEncoder密码
     *
     * @param password 密码
     * @return 加密字符串
     */
    public static String encryptPassword(String password) {
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        return passwordEncoder.encode(password);
    }

    /**
     * 判断密码是否相同
     *
     * @param rawPassword     真实密码
     * @param encodedPassword 加密后字符
     * @return 结果
     */
    public static boolean matchesPassword(String rawPassword, String encodedPassword) {
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        return passwordEncoder.matches(rawPassword, encodedPassword);
    }

}
