package plus.easydo.starter.oauth.core.model;

import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 拓展实现 UserDetails
 * @author yuzhanfeng
 * @param <T> 用户主键
 */
public class CustomizeUserDetails<T extends Serializable> implements UserDetails {
    private static final long serialVersionUID = 8081363717997957932L;
    /**
     * 帐号id
     */
    private T id;
    /**
     * 用户名
     */
    private String username;
    /**
     * 密码
     */
    private String password;
    /**
     * 组织ID
     */
    private Long depId;
    /**
     * 组织名称
     */
    private String deptName;
    /**
     * 用户角色
     */
    private List<SimpleGrantedAuthority> authorities;

    /**
     * 帐号是否过期
     */
    private boolean accountNonExpired = true;
    /**
     * 认证是否过期
     */
    private boolean credentialsNonExpired = true;
    /**
     * 帐号是否锁定
     */
    private boolean accountNonLocked = true;
    /**
     * 帐号是否删除
     */
    private boolean enabled = true;
    /**
     * 权限列表
     */
    private Collection<? extends Serializable> permissions;

    /**
     * 用户信息
     */
    private Map<String, Object> user;


    /**
     * 构造器
     */
    @SuppressWarnings("unchecked")
    public CustomizeUserDetails(Map<String,Object> user, List<SimpleGrantedAuthority> authorities, Set<String> permissions) {
        this.id = (T) user.get("id");
        this.username = (String) user.get("username");
        this.password = (String) user.get("password");
        this.authorities = authorities;
        this.user = user;
        this.permissions = permissions;
        user.remove("password");
    }


    /**
     * 获取用户角色列表
     * @return Collection
     */
    @Override
    public List<SimpleGrantedAuthority> getAuthorities() {
        return authorities;
    }

    public void setAuthorities(List<SimpleGrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    @Override
    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public void setAccountNonExpired(boolean accountNonExpired) {
        this.accountNonExpired = accountNonExpired;
    }

    @Override
    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public void setAccountNonLocked(boolean accountNonLocked) {
        this.accountNonLocked = accountNonLocked;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public void setCredentialsNonExpired(boolean credentialsNonExpired) {
        this.credentialsNonExpired = credentialsNonExpired;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public T getId() {
        return id;
    }

    public void setId(T id) {
        this.id = id;
    }

    public Long getDepId() {
        return depId;
    }

    public void setDepId(Long depId) {
        this.depId = depId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Collection<? extends Serializable> getPermissions() {
        return permissions;
    }

    public void setPermissions(Collection<? extends Serializable> permissions) {
        this.permissions = permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public Map<String, Object> getUser() {
        return user;
    }

    public void setUser(Map<String, Object> user) {
        this.user = user;
    }
}
