package plus.easydo.starter.oauth.core.exception;

import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;

/**
 * 自定义OAuth2异常类
 * @author yuzhanfeng
 */
public class CustomizeOAuth2Exception extends OAuth2Exception {

    private final int status;

    public CustomizeOAuth2Exception(String message, Throwable t) {
        super(message, t);
        this.status = ((OAuth2Exception)t).getHttpErrorCode();
    }

    public CustomizeOAuth2Exception(String message) {
        super(message);
        status = 500;
    }

    @Override
    public int getHttpErrorCode() {
        return status;
    }
}
