package plus.easydo.starter.oauth.core.config;


import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

/**
 * @author laoyu
 * @version 1.0
 */
public interface SecurityBeanConfig<T> {


    /**
     * 获得配置文件
     *
     * @return T
     * @author laoyu
     */
    T properties();

    /**
     * 功能描述
     *
     * @return org.springframework.security.oauth2.provider.ClientDetailsService
     * @author laoyu
     */
    ClientDetailsService getClientDetailsService();

    /**
     * 功能描述
     *
     * @return org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices
     * @author laoyu
     */
    AuthorizationServerTokenServices getAuthorizationServerTokenServices();
}
