/*
 * Decompiled with CFR 0.152.
 */
package plus.easydo.starter.web.core.config;

import feign.Logger;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import plus.easydo.starter.web.core.config.StarterFeignLogger;

@Configuration
public class StarterFeignConfigure {
    private ObjectFactory<HttpMessageConverters> messageConverters;

    @Autowired
    public void setMessageConverters(ObjectFactory<HttpMessageConverters> messageConverters) {
        this.messageConverters = messageConverters;
    }

    @Bean
    @Primary
    @Scope(value="prototype")
    public Encoder feignEncoder() {
        return new SpringFormEncoder((Encoder)new SpringEncoder(this.messageConverters));
    }

    @Bean
    public Logger.Level multipartLoggerLevel() {
        return Logger.Level.FULL;
    }

    @Bean
    public Logger logger() {
        return new StarterFeignLogger();
    }
}

