package plus.easydo.starter.web.core.config;

import feign.Logger;
import feign.Request;
import feign.Response;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

import java.io.IOException;

/**
 * @author laoyu
 * @version 1.0
 */
@Configuration
public class StarterFeignLogger extends Logger {

    private final org.slf4j.Logger logger;

    public StarterFeignLogger() {
        this(Logger.class);
    }

    public StarterFeignLogger(Class<?> clazz) {
        this(LoggerFactory.getLogger(clazz));
    }

    public StarterFeignLogger(String name) {
        this(LoggerFactory.getLogger(name));
    }

    public StarterFeignLogger(org.slf4j.Logger logger) {
        this.logger = logger;
    }

    @Override
    protected void logRequest(String configKey, Logger.Level logLevel, Request request) {
        if (this.logger.isInfoEnabled()) {
            super.logRequest(configKey, logLevel, request);
        }

    }

    @Override
    protected Response logAndRebufferResponse(String configKey, Logger.Level logLevel, Response response, long elapsedTime) throws IOException {
        return this.logger.isInfoEnabled() ? super.logAndRebufferResponse(configKey, logLevel, response, elapsedTime) : response;
    }

    @Override
    protected void log(String configKey, String format, Object... args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format(methodTag(configKey) + format, args));
        }

    }
}
