/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedList;
import org.codehaus.plexus.util.xml.XMLWriter;

public class PrettyPrintXMLWriter
implements XMLWriter {
    private PrintWriter writer;
    private LinkedList elementStack = new LinkedList();
    private boolean tagInProgress;
    private int depth;
    private String lineIndenter;
    private boolean readyForNewLine;
    private boolean tagIsEmpty;
    private boolean documentStarted;
    private String encoding;
    private String docType;

    public PrettyPrintXMLWriter(PrintWriter writer, String lineIndenter) {
        this.writer = writer;
        this.lineIndenter = lineIndenter;
    }

    public PrettyPrintXMLWriter(Writer writer, String lineIndenter) {
        this(new PrintWriter(writer), lineIndenter);
    }

    public PrettyPrintXMLWriter(PrintWriter writer) {
        this(writer, "  ");
    }

    public PrettyPrintXMLWriter(Writer writer) {
        this(new PrintWriter(writer));
    }

    public void setEncoding(String encoding) {
        if (this.documentStarted) {
            throw new IllegalStateException("encoding should be set before starting writing the document.");
        }
        this.encoding = encoding;
    }

    public void setDocType(String docType) {
        if (this.documentStarted) {
            throw new IllegalStateException("docType should be set before starting writing the document.");
        }
        this.docType = docType;
    }

    public void startElement(String name) {
        if (!this.documentStarted) {
            this.writeDocumentHeaders();
            this.documentStarted = true;
        }
        this.tagIsEmpty = false;
        this.finishTag();
        this.write("<");
        this.write(name);
        this.elementStack.addLast(name);
        this.tagInProgress = true;
        ++this.depth;
        this.readyForNewLine = true;
        this.tagIsEmpty = true;
    }

    public void writeText(String text) {
        this.writeText(text, true);
    }

    public void writeMarkup(String text) {
        this.writeText(text, false);
    }

    private void writeText(String text, boolean escapeHtml) {
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
        this.finishTag();
        if (escapeHtml) {
            text = text.replaceAll("&", "&amp;");
            text = text.replaceAll("<", "&lt;");
            text = text.replaceAll(">", "&gt;");
        }
        this.write(text);
    }

    public void addAttribute(String key, String value) {
        this.write(" ");
        this.write(key);
        this.write("=\"");
        this.write(value);
        this.write("\"");
    }

    public void endElement() {
        --this.depth;
        if (this.tagIsEmpty) {
            this.write("/");
            this.readyForNewLine = false;
            this.finishTag();
            this.elementStack.removeLast();
        } else {
            this.finishTag();
            this.write("</" + this.elementStack.removeLast() + ">");
        }
        this.readyForNewLine = true;
    }

    private void write(String str) {
        this.writer.write(str);
    }

    private void finishTag() {
        if (this.tagInProgress) {
            this.write(">");
        }
        this.tagInProgress = false;
        if (this.readyForNewLine) {
            this.endOfLine();
        }
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
    }

    protected void endOfLine() {
        this.write("\n");
        for (int i = 0; i < this.depth; ++i) {
            this.write(this.lineIndenter);
        }
    }

    private void writeDocumentHeaders() {
        this.write("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            this.write(" encoding=\"" + this.encoding + "\"");
        }
        this.write("?>");
        this.endOfLine();
        if (this.docType != null) {
            this.write("<!DOCTYPE ");
            this.write(this.docType);
            this.write(">");
            this.endOfLine();
        }
    }
}

