/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml.pull;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class MXSerializer
implements XmlSerializer {
    protected static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    protected static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final boolean TRACE_SIZING = false;
    protected final String FEATURE_SERIALIZER_ATTVALUE_USE_APOSTROPHE = "http://xmlpull.org/v1/doc/features.html#serializer-attvalue-use-apostrophe";
    protected final String FEATURE_NAMES_INTERNED = "http://xmlpull.org/v1/doc/features.html#names-interned";
    protected final String PROPERTY_SERIALIZER_INDENTATION = "http://xmlpull.org/v1/doc/properties.html#serializer-indentation";
    protected final String PROPERTY_SERIALIZER_LINE_SEPARATOR = "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator";
    protected static final String PROPERTY_LOCATION = "http://xmlpull.org/v1/doc/properties.html#location";
    protected boolean namesInterned;
    protected boolean attributeUseApostrophe;
    protected String indentationString = null;
    protected String lineSeparator = "\n";
    protected String location;
    protected Writer out;
    protected int autoDeclaredPrefixes;
    protected int depth = 0;
    protected String[] elNamespace = new String[2];
    protected String[] elName = new String[this.elNamespace.length];
    protected int[] elNamespaceCount = new int[this.elNamespace.length];
    protected int namespaceEnd = 0;
    protected String[] namespacePrefix = new String[8];
    protected String[] namespaceUri = new String[this.namespacePrefix.length];
    protected boolean finished;
    protected boolean pastRoot;
    protected boolean setPrefixCalled;
    protected boolean startTagIncomplete;
    protected boolean doIndent;
    protected boolean seenTag;
    protected boolean seenBracket;
    protected boolean seenBracketBracket;
    private static final int BUF_LEN = Runtime.getRuntime().freeMemory() > 1000000L ? 8192 : 256;
    protected char[] buf = new char[BUF_LEN];
    protected static final String[] precomputedPrefixes = new String[32];
    private boolean checkNamesInterned = false;
    protected int offsetNewLine;
    protected int indentationJump;
    protected char[] indentationBuf;
    protected int maxIndentLevel;
    protected boolean writeLineSepartor;
    protected boolean writeIndentation;

    static {
        int n = 0;
        while (n < precomputedPrefixes.length) {
            MXSerializer.precomputedPrefixes[n] = ("n" + n).intern();
            ++n;
        }
    }

    private static void addPrintable(StringBuffer stringBuffer, char c) {
        switch (c) {
            case '\b': {
                stringBuffer.append("\\b");
                break;
            }
            case '\t': {
                stringBuffer.append("\\t");
                break;
            }
            case '\n': {
                stringBuffer.append("\\n");
                break;
            }
            case '\f': {
                stringBuffer.append("\\f");
                break;
            }
            case '\r': {
                stringBuffer.append("\\r");
                break;
            }
            case '\"': {
                stringBuffer.append("\\\"");
                break;
            }
            case '\'': {
                stringBuffer.append("\\'");
                break;
            }
            case '\\': {
                stringBuffer.append("\\\\");
                break;
            }
            default: {
                if (c < ' ' || c > '~') {
                    String string = "0000" + Integer.toString(c, 16);
                    stringBuffer.append("\\u" + string.substring(string.length() - 4, string.length()));
                    break;
                }
                stringBuffer.append(c);
            }
        }
    }

    public XmlSerializer attribute(String string, String string2, String string3) throws IOException {
        if (!this.startTagIncomplete) {
            throw new IllegalArgumentException("startTag() must be called before attribute()" + this.getLocation());
        }
        this.out.write(32);
        if (string != null && string.length() > 0) {
            if (!this.namesInterned) {
                string = string.intern();
            } else if (this.checkNamesInterned) {
                this.checkInterning(string);
            }
            String string4 = this.lookupOrDeclarePrefix(string);
            if (string4.length() == 0) {
                string4 = this.generatePrefix(string);
            }
            this.out.write(string4);
            this.out.write(58);
        }
        this.out.write(string2);
        this.out.write(61);
        this.out.write(this.attributeUseApostrophe ? 39 : 34);
        this.writeAttributeValue(string3, this.out);
        this.out.write(this.attributeUseApostrophe ? 39 : 34);
        return this;
    }

    public void cdsect(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<![CDATA[");
        this.out.write(string);
        this.out.write("]]>");
    }

    private void checkInterning(String string) {
        if (this.namesInterned && string != string.intern()) {
            throw new IllegalArgumentException("all names passed as arguments must be internedwhen NAMES INTERNED feature is enabled");
        }
    }

    protected void closeStartTag() throws IOException {
        if (this.finished) {
            throw new IllegalArgumentException("trying to write past already finished output" + this.getLocation());
        }
        if (this.seenBracket) {
            this.seenBracketBracket = false;
            this.seenBracket = false;
        }
        if (this.startTagIncomplete || this.setPrefixCalled) {
            if (this.setPrefixCalled) {
                throw new IllegalArgumentException("startTag() must be called immediately after setPrefix()" + this.getLocation());
            }
            if (!this.startTagIncomplete) {
                throw new IllegalArgumentException("trying to close start tag that is not opened" + this.getLocation());
            }
            this.writeNamespaceDeclarations();
            this.out.write(62);
            this.elNamespaceCount[this.depth] = this.namespaceEnd;
            this.startTagIncomplete = false;
        }
    }

    public void comment(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<!--");
        this.out.write(string);
        this.out.write("-->");
    }

    public void docdecl(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<!DOCTYPE");
        this.out.write(string);
        this.out.write(">");
    }

    public void endDocument() throws IOException {
        while (this.depth > 0) {
            this.endTag(this.elNamespace[this.depth], this.elName[this.depth]);
        }
        this.startTagIncomplete = true;
        this.pastRoot = true;
        this.finished = true;
        this.out.flush();
    }

    public XmlSerializer endTag(String string, String string2) throws IOException {
        this.seenBracketBracket = false;
        this.seenBracket = false;
        if (string != null) {
            if (!this.namesInterned) {
                string = string.intern();
            } else if (this.checkNamesInterned) {
                this.checkInterning(string);
            }
        }
        if (string != this.elNamespace[this.depth]) {
            throw new IllegalArgumentException("expected namespace " + MXSerializer.printable(this.elNamespace[this.depth]) + " and not " + MXSerializer.printable(string) + this.getLocation());
        }
        if (string2 == null) {
            throw new IllegalArgumentException("end tag name can not be null" + this.getLocation());
        }
        if (this.checkNamesInterned && this.namesInterned) {
            this.checkInterning(string2);
        }
        if (!this.namesInterned && !string2.equals(this.elName[this.depth]) || this.namesInterned && string2 != this.elName[this.depth]) {
            throw new IllegalArgumentException("expected element name " + MXSerializer.printable(this.elName[this.depth]) + " and not " + MXSerializer.printable(string2) + this.getLocation());
        }
        if (this.startTagIncomplete) {
            this.writeNamespaceDeclarations();
            this.out.write(" />");
            --this.depth;
        } else {
            String string3;
            --this.depth;
            if (this.doIndent && this.seenTag) {
                this.writeIndent();
            }
            this.out.write("</");
            if (string != null && string.length() > 0 && (string3 = this.lookupOrDeclarePrefix(string)).length() > 0) {
                this.out.write(string3);
                this.out.write(58);
            }
            this.out.write(string2);
            this.out.write(62);
        }
        this.namespaceEnd = this.elNamespaceCount[this.depth];
        this.startTagIncomplete = false;
        this.seenTag = true;
        return this;
    }

    protected void ensureElementsCapacity() {
        int n = this.elName.length;
        int n2 = (this.depth >= 7 ? 2 * this.depth : 8) + 2;
        boolean bl = n > 0;
        String[] stringArray = null;
        stringArray = new String[n2];
        if (bl) {
            System.arraycopy(this.elName, 0, stringArray, 0, n);
        }
        this.elName = stringArray;
        stringArray = new String[n2];
        if (bl) {
            System.arraycopy(this.elNamespace, 0, stringArray, 0, n);
        }
        this.elNamespace = stringArray;
        int[] nArray = new int[n2];
        if (bl) {
            System.arraycopy(this.elNamespaceCount, 0, nArray, 0, n);
        } else {
            nArray[0] = 0;
        }
        this.elNamespaceCount = nArray;
    }

    protected void ensureNamespacesCapacity() {
        int n = this.namespaceEnd > 7 ? 2 * this.namespaceEnd : 8;
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        if (this.namespacePrefix != null) {
            System.arraycopy(this.namespacePrefix, 0, stringArray, 0, this.namespaceEnd);
            System.arraycopy(this.namespaceUri, 0, stringArray2, 0, this.namespaceEnd);
        }
        this.namespacePrefix = stringArray;
        this.namespaceUri = stringArray2;
    }

    public void entityRef(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write(38);
        this.out.write(string);
        this.out.write(59);
    }

    public void flush() throws IOException {
        if (!this.finished && this.startTagIncomplete) {
            this.closeStartTag();
        }
        this.out.flush();
    }

    private String generatePrefix(String string) {
        ++this.autoDeclaredPrefixes;
        String string2 = this.autoDeclaredPrefixes < precomputedPrefixes.length ? precomputedPrefixes[this.autoDeclaredPrefixes] : ("n" + this.autoDeclaredPrefixes).intern();
        int n = this.namespaceEnd - 1;
        while (n >= 0) {
            if (string2 == this.namespacePrefix[n]) {
                // empty if block
            }
            --n;
        }
        if (this.namespaceEnd >= this.namespacePrefix.length) {
            this.ensureNamespacesCapacity();
        }
        this.namespacePrefix[this.namespaceEnd] = string2;
        this.namespaceUri[this.namespaceEnd] = string;
        ++this.namespaceEnd;
        return string2;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean getFeature(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("feature name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/features.html#names-interned".equals(string)) {
            return this.namesInterned;
        }
        if ("http://xmlpull.org/v1/doc/features.html#serializer-attvalue-use-apostrophe".equals(string)) {
            return this.attributeUseApostrophe;
        }
        return false;
    }

    private String getLocation() {
        return this.location != null ? " @" + this.location : "";
    }

    public String getName() {
        return this.elName[this.depth];
    }

    public String getNamespace() {
        return this.elNamespace[this.depth];
    }

    public String getPrefix(String string, boolean bl) {
        if (!this.namesInterned) {
            string = string.intern();
        } else if (this.checkNamesInterned) {
            this.checkInterning(string);
        }
        if (string == null) {
            throw new IllegalArgumentException("namespace must be not null" + this.getLocation());
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("default namespace cannot have prefix" + this.getLocation());
        }
        int n = this.namespaceEnd - 1;
        while (n >= 0) {
            if (string == this.namespaceUri[n]) {
                String string2 = this.namespacePrefix[n];
                int n2 = this.namespaceEnd - 1;
                while (n2 > n) {
                    if (string2 == this.namespacePrefix[n2]) {
                        // empty if block
                    }
                    --n2;
                }
                return string2;
            }
            --n;
        }
        if (!bl) {
            return null;
        }
        return this.generatePrefix(string);
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("property name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/properties.html#serializer-indentation".equals(string)) {
            return this.indentationString;
        }
        if ("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator".equals(string)) {
            return this.lineSeparator;
        }
        if (PROPERTY_LOCATION.equals(string)) {
            return this.location;
        }
        return null;
    }

    public Writer getWriter() {
        return this.out;
    }

    public void ignorableWhitespace(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty string is not allowed for ignorable whitespace" + this.getLocation());
        }
        this.out.write(string);
    }

    protected String lookupOrDeclarePrefix(String string) {
        return this.getPrefix(string, true);
    }

    protected static final String printable(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        MXSerializer.addPrintable(stringBuffer, c);
        return stringBuffer.toString();
    }

    protected static final String printable(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 16);
        stringBuffer.append("'");
        int n = 0;
        while (n < string.length()) {
            MXSerializer.addPrintable(stringBuffer, string.charAt(n));
            ++n;
        }
        stringBuffer.append("'");
        return stringBuffer.toString();
    }

    public void processingInstruction(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.out.write("<?");
        this.out.write(string);
        this.out.write("?>");
    }

    protected void rebuildIndentationBuf() {
        int n;
        if (!this.doIndent) {
            return;
        }
        int n2 = 65;
        int n3 = 0;
        this.offsetNewLine = 0;
        if (this.writeLineSepartor) {
            this.offsetNewLine = this.lineSeparator.length();
            n3 += this.offsetNewLine;
        }
        this.maxIndentLevel = 0;
        if (this.writeIndentation) {
            this.indentationJump = this.indentationString.length();
            this.maxIndentLevel = 65 / this.indentationJump;
            n3 += this.maxIndentLevel * this.indentationJump;
        }
        if (this.indentationBuf == null || this.indentationBuf.length < n3) {
            this.indentationBuf = new char[n3 + 8];
        }
        int n4 = 0;
        if (this.writeLineSepartor) {
            n = 0;
            while (n < this.lineSeparator.length()) {
                this.indentationBuf[n4++] = this.lineSeparator.charAt(n);
                ++n;
            }
        }
        if (this.writeIndentation) {
            n = 0;
            while (n < this.maxIndentLevel) {
                int n5 = 0;
                while (n5 < this.indentationString.length()) {
                    this.indentationBuf[n4++] = this.indentationString.charAt(n5);
                    ++n5;
                }
                ++n;
            }
        }
    }

    protected void reset() {
        this.location = null;
        this.out = null;
        this.autoDeclaredPrefixes = 0;
        this.depth = 0;
        int n = 0;
        while (n < this.elNamespaceCount.length) {
            this.elName[n] = null;
            this.elNamespace[n] = null;
            this.elNamespaceCount[n] = 2;
            ++n;
        }
        this.namespaceEnd = 0;
        this.namespacePrefix[this.namespaceEnd] = "xmlns";
        this.namespaceUri[this.namespaceEnd] = XMLNS_URI;
        ++this.namespaceEnd;
        this.namespacePrefix[this.namespaceEnd] = "xml";
        this.namespaceUri[this.namespaceEnd] = XML_URI;
        ++this.namespaceEnd;
        this.finished = false;
        this.pastRoot = false;
        this.setPrefixCalled = false;
        this.startTagIncomplete = false;
        this.seenTag = false;
        this.seenBracket = false;
        this.seenBracketBracket = false;
    }

    public void setFeature(String string, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("feature name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/features.html#names-interned".equals(string)) {
            this.namesInterned = bl;
        } else if ("http://xmlpull.org/v1/doc/features.html#serializer-attvalue-use-apostrophe".equals(string)) {
            this.attributeUseApostrophe = bl;
        } else {
            throw new IllegalStateException("unsupported feature " + string);
        }
    }

    public void setOutput(OutputStream outputStream, String string) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("output stream can not be null");
        }
        this.reset();
        this.out = string != null ? new OutputStreamWriter(outputStream, string) : new OutputStreamWriter(outputStream);
    }

    public void setOutput(Writer writer) {
        this.reset();
        this.out = writer;
    }

    public void setPrefix(String string, String string2) throws IOException {
        if (this.startTagIncomplete) {
            this.closeStartTag();
        }
        if (string == null) {
            string = "";
        }
        if (!this.namesInterned) {
            string = string.intern();
        } else if (this.checkNamesInterned) {
            this.checkInterning(string);
        } else if (string == null) {
            throw new IllegalArgumentException("prefix must be not null" + this.getLocation());
        }
        int n = this.elNamespaceCount[this.depth];
        while (n < this.namespaceEnd) {
            if (string == this.namespacePrefix[n]) {
                throw new IllegalStateException("duplicated prefix " + MXSerializer.printable(string) + this.getLocation());
            }
            ++n;
        }
        if (!this.namesInterned) {
            string2 = string2.intern();
        } else if (this.checkNamesInterned) {
            this.checkInterning(string2);
        } else if (string2 == null) {
            throw new IllegalArgumentException("namespace must be not null" + this.getLocation());
        }
        if (this.namespaceEnd >= this.namespacePrefix.length) {
            this.ensureNamespacesCapacity();
        }
        this.namespacePrefix[this.namespaceEnd] = string;
        this.namespaceUri[this.namespaceEnd] = string2;
        ++this.namespaceEnd;
        this.setPrefixCalled = true;
    }

    public void setProperty(String string, Object object) throws IllegalArgumentException, IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("property name can not be null");
        }
        if ("http://xmlpull.org/v1/doc/properties.html#serializer-indentation".equals(string)) {
            this.indentationString = (String)object;
        } else if ("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator".equals(string)) {
            this.lineSeparator = (String)object;
        } else if (PROPERTY_LOCATION.equals(string)) {
            this.location = (String)object;
        } else {
            throw new IllegalStateException("unsupported property " + string);
        }
        this.writeLineSepartor = this.lineSeparator != null && this.lineSeparator.length() > 0;
        this.writeIndentation = this.indentationString != null && this.indentationString.length() > 0;
        this.doIndent = this.indentationString != null && (this.writeLineSepartor || this.writeIndentation);
        this.rebuildIndentationBuf();
        this.seenTag = false;
    }

    public void startDocument(String string, Boolean bl) throws IOException {
        int n;
        int n2 = n = this.attributeUseApostrophe ? 39 : 34;
        if (this.attributeUseApostrophe) {
            this.out.write("<?xml version='1.0'");
        } else {
            this.out.write("<?xml version=\"1.0\"");
        }
        if (string != null) {
            this.out.write(" encoding=");
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
            this.out.write(string);
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
        }
        if (bl != null) {
            this.out.write(" standalone=");
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
            if (bl.booleanValue()) {
                this.out.write("yes");
            } else {
                this.out.write("no");
            }
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
        }
        this.out.write("?>");
    }

    public XmlSerializer startTag(String string, String string2) throws IOException {
        if (this.startTagIncomplete) {
            this.closeStartTag();
        }
        this.seenBracketBracket = false;
        this.seenBracket = false;
        if (this.doIndent && this.depth > 0 && this.seenTag) {
            this.writeIndent();
        }
        this.seenTag = true;
        this.setPrefixCalled = false;
        this.startTagIncomplete = true;
        ++this.depth;
        if (this.depth + 1 >= this.elName.length) {
            this.ensureElementsCapacity();
        }
        if (this.checkNamesInterned && this.namesInterned) {
            this.checkInterning(string);
        }
        String string3 = this.elNamespace[this.depth] = this.namesInterned || string == null ? string : string.intern();
        if (this.checkNamesInterned && this.namesInterned) {
            this.checkInterning(string2);
        }
        String string4 = this.elName[this.depth] = this.namesInterned || string2 == null ? string2 : string2.intern();
        if (this.out == null) {
            throw new IllegalStateException("setOutput() must called set before serialization can start");
        }
        this.out.write(60);
        if (string != null) {
            if (string.length() > 0) {
                String string5;
                String string6 = null;
                if (this.depth > 0 && this.namespaceEnd - this.elNamespaceCount[this.depth - 1] == 1 && ((string5 = this.namespaceUri[this.namespaceEnd - 1]) == string || string5.equals(string))) {
                    String string7 = this.namespacePrefix[this.namespaceEnd - 1];
                    int n = this.elNamespaceCount[this.depth - 1] - 1;
                    while (n >= 2) {
                        String string8 = this.namespacePrefix[n];
                        if (string8 == string7 || string8.equals(string7)) {
                            String string9 = this.namespaceUri[n];
                            if (string9 != string5 && !string9.equals(string5)) break;
                            --this.namespaceEnd;
                            string6 = string7;
                            break;
                        }
                        --n;
                    }
                }
                if (string6 == null) {
                    string6 = this.lookupOrDeclarePrefix(string);
                }
                if (string6.length() > 0) {
                    this.out.write(string6);
                    this.out.write(58);
                }
            } else {
                int n = this.namespaceEnd - 1;
                while (n >= 0) {
                    if (this.namespacePrefix[n] == "") {
                        String string10 = this.namespaceUri[n];
                        if (string10 == null) {
                            this.setPrefix("", "");
                            break;
                        }
                        if (string10.length() <= 0) break;
                        throw new IllegalStateException("start tag can not be written in empty default namespace as default namespace is currently bound to '" + string10 + "'" + this.getLocation());
                    }
                    --n;
                }
            }
        }
        this.out.write(string2);
        return this;
    }

    public XmlSerializer text(String string) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.writeElementContent(string, this.out);
        return this;
    }

    public XmlSerializer text(char[] cArray, int n, int n2) throws IOException {
        if (this.startTagIncomplete || this.setPrefixCalled) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        this.writeElementContent(cArray, n, n2, this.out);
        return this;
    }

    protected void writeAttributeValue(String string, Writer writer) throws IOException {
        char c = this.attributeUseApostrophe ? (char)'\'' : '\"';
        String string2 = this.attributeUseApostrophe ? "&apos;" : "&quot;";
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '&') {
                if (n2 > n) {
                    writer.write(string.substring(n, n2));
                }
                writer.write("&amp;");
                n = n2 + 1;
            }
            if (c2 == '<') {
                if (n2 > n) {
                    writer.write(string.substring(n, n2));
                }
                writer.write("&lt;");
                n = n2 + 1;
            } else if (c2 == c) {
                if (n2 > n) {
                    writer.write(string.substring(n, n2));
                }
                writer.write(string2);
                n = n2 + 1;
            } else if (c2 < ' ') {
                if (c2 == '\r' || c2 == '\n' || c2 == '\t') {
                    if (n2 > n) {
                        writer.write(string.substring(n, n2));
                    }
                    writer.write("&#");
                    writer.write(Integer.toString(c2));
                    writer.write(59);
                    n = n2 + 1;
                } else {
                    throw new IllegalStateException("character " + Integer.toString(c2) + " is not allowed in output" + this.getLocation());
                }
            }
            ++n2;
        }
        if (n > 0) {
            writer.write(string.substring(n));
        } else {
            writer.write(string);
        }
    }

    protected void writeElementContent(String string, Writer writer) throws IOException {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == ']') {
                if (this.seenBracket) {
                    this.seenBracketBracket = true;
                } else {
                    this.seenBracket = true;
                }
            } else {
                if (c == '&') {
                    if (n2 > n) {
                        writer.write(string.substring(n, n2));
                    }
                    writer.write("&amp;");
                    n = n2 + 1;
                } else if (c == '<') {
                    if (n2 > n) {
                        writer.write(string.substring(n, n2));
                    }
                    writer.write("&lt;");
                    n = n2 + 1;
                } else if (this.seenBracketBracket && c == '>') {
                    if (n2 > n) {
                        writer.write(string.substring(n, n2));
                    }
                    writer.write("&gt;");
                    n = n2 + 1;
                } else if (c < ' ' && c != '\t' && c != '\n' && c != '\r') {
                    throw new IllegalStateException("character " + Integer.toString(c) + " is not allowed in output" + this.getLocation());
                }
                if (this.seenBracket) {
                    this.seenBracket = false;
                    this.seenBracketBracket = false;
                }
            }
            ++n2;
        }
        if (n > 0) {
            writer.write(string.substring(n));
        } else {
            writer.write(string);
        }
    }

    protected void writeElementContent(char[] cArray, int n, int n2, Writer writer) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        int n5 = n;
        while (n5 < n3) {
            char c = cArray[n5];
            if (c == ']') {
                if (this.seenBracket) {
                    this.seenBracketBracket = true;
                } else {
                    this.seenBracket = true;
                }
            } else {
                if (c == '&') {
                    if (n5 > n4) {
                        writer.write(cArray, n4, n5 - n4);
                    }
                    writer.write("&amp;");
                    n4 = n5 + 1;
                } else if (c == '<') {
                    if (n5 > n4) {
                        writer.write(cArray, n4, n5 - n4);
                    }
                    writer.write("&lt;");
                    n4 = n5 + 1;
                } else if (this.seenBracketBracket && c == '>') {
                    if (n5 > n4) {
                        writer.write(cArray, n4, n5 - n4);
                    }
                    writer.write("&gt;");
                    n4 = n5 + 1;
                } else if (c < ' ' && c != '\t' && c != '\n' && c != '\r') {
                    throw new IllegalStateException("character " + Integer.toString(c) + " is not allowed in output" + this.getLocation());
                }
                if (this.seenBracket) {
                    this.seenBracket = false;
                    this.seenBracketBracket = false;
                }
            }
            ++n5;
        }
        if (n3 > n4) {
            writer.write(cArray, n4, n3 - n4);
        }
    }

    protected void writeIndent() throws IOException {
        int n = this.writeLineSepartor ? 0 : this.offsetNewLine;
        int n2 = this.depth > this.maxIndentLevel ? this.maxIndentLevel : this.depth;
        this.out.write(this.indentationBuf, n, n2 * this.indentationJump + this.offsetNewLine);
    }

    private void writeNamespaceDeclarations() throws IOException {
        int n = this.elNamespaceCount[this.depth - 1];
        while (n < this.namespaceEnd) {
            if (this.doIndent && this.namespaceUri[n].length() > 40) {
                this.writeIndent();
                this.out.write(" ");
            }
            if (this.namespacePrefix[n] != "") {
                this.out.write(" xmlns:");
                this.out.write(this.namespacePrefix[n]);
                this.out.write(61);
            } else {
                this.out.write(" xmlns=");
            }
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
            this.writeAttributeValue(this.namespaceUri[n], this.out);
            this.out.write(this.attributeUseApostrophe ? 39 : 34);
            ++n;
        }
    }
}

