/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.dag;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.Vertex;

public class CycleDetector {
    private static final Integer NOT_VISTITED = new Integer(0);
    private static final Integer VISITING = new Integer(1);
    private static final Integer VISITED = new Integer(2);

    private static boolean dfsVisit(Vertex vertex, LinkedList linkedList, Map map) {
        linkedList.addFirst(vertex.getLabel());
        map.put(vertex, VISITING);
        List list = vertex.getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Vertex vertex2 = (Vertex)iterator.next();
            if (CycleDetector.isNotVisited(vertex2, map)) {
                boolean bl = CycleDetector.dfsVisit(vertex2, linkedList, map);
                if (!bl) continue;
                return true;
            }
            if (!CycleDetector.isVisiting(vertex2, map)) continue;
            linkedList.addFirst(vertex2.getLabel());
            return true;
        }
        map.put(vertex, VISITED);
        linkedList.removeFirst();
        return false;
    }

    public static List hasCycle(DAG dAG) {
        List list = dAG.getVerticies();
        HashMap hashMap = new HashMap();
        List list2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Vertex vertex = (Vertex)iterator.next();
            if (CycleDetector.isNotVisited(vertex, hashMap) && (list2 = CycleDetector.introducesCycle(vertex, hashMap)) != null) break;
        }
        return list2;
    }

    public static List introducesCycle(Vertex vertex) {
        HashMap hashMap = new HashMap();
        return CycleDetector.introducesCycle(vertex, hashMap);
    }

    public static List introducesCycle(Vertex vertex, Map map) {
        LinkedList linkedList = new LinkedList();
        boolean bl = CycleDetector.dfsVisit(vertex, linkedList, map);
        if (bl) {
            String string = (String)linkedList.getFirst();
            int n = linkedList.lastIndexOf(string);
            List list = linkedList.subList(0, n + 1);
            Collections.reverse(list);
            return list;
        }
        return null;
    }

    private static boolean isNotVisited(Vertex vertex, Map map) {
        if (!map.containsKey(vertex)) {
            return true;
        }
        Integer n = (Integer)map.get(vertex);
        return NOT_VISTITED.equals(n);
    }

    private static boolean isVisiting(Vertex vertex, Map map) {
        Integer n = (Integer)map.get(vertex);
        return VISITING.equals(n);
    }
}

