/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.cli;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.codehaus.plexus.util.cli.CommandLineException;

public class Commandline
implements Cloneable {
    protected static final String OS_NAME = "os.name";
    protected static final String WINDOWS = "Windows";
    private String shell = null;
    private Vector shellArgs = new Vector();
    protected String executable = null;
    protected Vector arguments = new Vector();
    protected Vector envVars = new Vector();
    private boolean newEnvironment = false;
    private File workingDir = null;

    public Commandline() {
        this.setDefaultShell();
    }

    public Commandline(String string) {
        this.setDefaultShell();
        String[] stringArray = new String[]{};
        try {
            stringArray = Commandline.translateCommandline(string);
        }
        catch (Exception exception) {
            System.err.println("Error translating Commandline.");
        }
        if (stringArray != null && stringArray.length > 0) {
            this.setExecutable(stringArray[0]);
            int n = 1;
            while (n < stringArray.length) {
                this.createArgument().setValue(stringArray[n]);
                ++n;
            }
        }
    }

    public void addArguments(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.createArgument().setValue(stringArray[n]);
            ++n;
        }
    }

    public void addEnvironment(String string, String string2) {
        this.envVars.add(String.valueOf(string) + "=" + string2);
        this.newEnvironment = true;
    }

    public void clear() {
        this.executable = null;
        this.arguments.removeAllElements();
    }

    public void clearArgs() {
        this.arguments.removeAllElements();
    }

    public Object clone() {
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.executable);
        commandline.addArguments(this.getArguments());
        return commandline;
    }

    public Argument createArgument() {
        return this.createArgument(false);
    }

    public Argument createArgument(boolean bl) {
        Argument argument = new Argument();
        if (bl) {
            this.arguments.insertElementAt(argument, 0);
        } else {
            this.arguments.addElement(argument);
        }
        return argument;
    }

    public Marker createMarker() {
        return new Marker(this.arguments.size());
    }

    public Process execute() throws CommandLineException {
        Process process = null;
        try {
            if (this.workingDir == null) {
                process = Runtime.getRuntime().exec(this.getShellCommandline(), this.getCurrentEnvironment());
            } else {
                if (!this.workingDir.exists()) {
                    throw new CommandLineException("Working directory \"" + this.workingDir.getPath() + "\" does not exist!");
                }
                if (!this.workingDir.isDirectory()) {
                    throw new CommandLineException("Path \"" + this.workingDir.getPath() + "\" does not specify a directory.");
                }
                process = Runtime.getRuntime().exec(this.getShellCommandline(), this.getCurrentEnvironment(), this.workingDir);
            }
        }
        catch (IOException iOException) {
            throw new CommandLineException("Error while executing process.", iOException);
        }
        return process;
    }

    public String[] getArguments() {
        Object object;
        Vector<String> vector = new Vector<String>(this.arguments.size() * 2);
        int n = 0;
        while (n < this.arguments.size()) {
            object = (Argument)this.arguments.elementAt(n);
            String[] stringArray = ((Argument)object).getParts();
            if (stringArray != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    vector.addElement(stringArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public String[] getCommandline() {
        String[] stringArray = this.getArguments();
        if (this.executable == null) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = this.executable;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    public String[] getCurrentEnvironment() {
        if (!this.newEnvironment) {
            return null;
        }
        return this.getEnvironments();
    }

    public String[] getEnvironments() {
        return this.envVars.toArray(new String[this.envVars.size()]);
    }

    public String getExecutable() {
        return this.executable;
    }

    public String[] getShellCommandline() {
        int n = 0;
        int n2 = 0;
        if (this.shell != null) {
            n = 1;
        }
        String[] stringArray = this.getArguments();
        String[] stringArray2 = new String[(n += this.shellArgs.size()) + stringArray.length + (this.executable == null ? 0 : 1)];
        if (this.shell != null) {
            stringArray2[0] = this.shell;
            ++n2;
        }
        System.arraycopy(this.shellArgs.toArray(), 0, stringArray2, n2, this.shellArgs.size());
        n2 += this.shellArgs.size();
        if (this.executable != null) {
            stringArray2[n2] = this.executable;
            ++n2;
        }
        System.arraycopy(stringArray, 0, stringArray2, n2, stringArray.length);
        return stringArray2;
    }

    public File getWorkingDirectory() {
        return this.workingDir;
    }

    public static String quoteArgument(String string) throws CommandLineException {
        if (string.indexOf("\"") > -1) {
            if (string.indexOf("'") > -1) {
                throw new CommandLineException("Can't handle single and double quotes in same argument");
            }
            return String.valueOf('\'') + string + '\'';
        }
        if (string.indexOf("'") > -1 || string.indexOf(" ") > -1) {
            return String.valueOf('\"') + string + '\"';
        }
        return string;
    }

    private void setDefaultShell() {
        String string = System.getProperty(OS_NAME);
        if (string.indexOf(WINDOWS) != -1) {
            if (string.indexOf("95") != -1 || string.indexOf("98") != -1 || string.indexOf("Me") != -1) {
                this.shell = "COMMAND.COM";
                this.shellArgs.add("/C");
            } else {
                this.shell = "CMD.EXE";
                this.shellArgs.add("/X");
                this.shellArgs.add("/C");
            }
        }
    }

    public void setExecutable(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.executable = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public void setWorkingDirectory(String string) {
        if (string != null) {
            this.workingDir = new File(string);
        }
    }

    public int size() {
        return this.getCommandline().length;
    }

    public String toString() {
        return Commandline.toString(this.getCommandline());
    }

    public static String toString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            try {
                stringBuffer.append(Commandline.quoteArgument(stringArray[n]));
            }
            catch (Exception exception) {
                System.err.println("Error quoting argument.");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String[] translateCommandline(String string) throws Exception {
        Object[] objectArray;
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        boolean bl = false;
        boolean bl2 = true;
        int n = 2;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"' ", true);
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        block4: while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken();
            switch (n2) {
                case 1: {
                    if ("'".equals(objectArray)) {
                        n2 = 0;
                        break;
                    }
                    stringBuffer.append((String)objectArray);
                    break;
                }
                case 2: {
                    if ("\"".equals(objectArray)) {
                        n2 = 0;
                        break;
                    }
                    stringBuffer.append((String)objectArray);
                    break;
                }
                default: {
                    if ("'".equals(objectArray)) {
                        n2 = 1;
                        break;
                    }
                    if ("\"".equals(objectArray)) {
                        n2 = 2;
                        break;
                    }
                    if (" ".equals(objectArray)) {
                        if (stringBuffer.length() == 0) continue block4;
                        vector.addElement(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        break;
                    }
                    stringBuffer.append((String)objectArray);
                    break;
                }
            }
        }
        if (stringBuffer.length() != 0) {
            vector.addElement(stringBuffer.toString());
        }
        if (n2 == 1 || n2 == 2) {
            throw new CommandLineException("unbalanced quotes in " + string);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static class Argument {
        private String[] parts;

        public String[] getParts() {
            return this.parts;
        }

        public void setFile(File file) {
            this.parts = new String[]{file.getAbsolutePath()};
        }

        public void setLine(String string) {
            if (string == null) {
                return;
            }
            try {
                this.parts = Commandline.translateCommandline(string);
            }
            catch (Exception exception) {
                System.err.println("Error translating Commandline.");
            }
        }

        public void setValue(String string) {
            this.parts = new String[]{string};
        }
    }

    public class Marker {
        private int position;
        private int realPos = -1;

        Marker(int n) {
            this.position = n;
        }

        public int getPosition() {
            if (this.realPos == -1) {
                this.realPos = Commandline.this.executable == null ? 0 : 1;
                int n = 0;
                while (n < this.position) {
                    Argument argument = (Argument)Commandline.this.arguments.elementAt(n);
                    this.realPos += argument.getParts().length;
                    ++n;
                }
            }
            return this.realPos;
        }
    }
}

