/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class StringUtils {
    public static String abbreviate(String string, int n) {
        return StringUtils.abbreviate(string, 0, n);
    }

    public static String abbreviate(String string, int n, int n2) {
        if (n2 < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (string.length() <= n2) {
            return string;
        }
        if (n > string.length()) {
            n = string.length();
        }
        if (string.length() - n < n2 - 3) {
            n = string.length() - (n2 - 3);
        }
        if (n <= 4) {
            return String.valueOf(string.substring(0, n2 - 3)) + "...";
        }
        if (n2 < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (n + (n2 - 3) < string.length()) {
            return "..." + StringUtils.abbreviate(string.substring(n), n2 - 3);
        }
        return "..." + string.substring(string.length() - (n2 - 3));
    }

    public static String addAndDeHump(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (n != 0 && Character.isUpperCase(string.charAt(n))) {
                stringBuffer.append('-');
            }
            stringBuffer.append(string.charAt(n));
            ++n;
        }
        return stringBuffer.toString().trim().toLowerCase();
    }

    public static String capitalise(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        return new StringBuffer(string.length()).append(Character.toTitleCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    public static String capitaliseAllWords(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Character.isWhitespace(c)) {
                stringBuffer.append(c);
                bl = true;
            } else if (bl) {
                stringBuffer.append(Character.toTitleCase(c));
                bl = false;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String capitalizeFirstLetter(String string) {
        String string2 = string.substring(0, 1).toUpperCase();
        String string3 = string.substring(1);
        return String.valueOf(string2) + string3;
    }

    public static String center(String string, int n) {
        return StringUtils.center(string, n, " ");
    }

    public static String center(String string, int n, String string2) {
        int n2 = string.length();
        int n3 = n - n2;
        if (n3 < 1) {
            return string;
        }
        string = StringUtils.leftPad(string, n2 + n3 / 2, string2);
        string = StringUtils.rightPad(string, n, string2);
        return string;
    }

    public static String chomp(String string) {
        return StringUtils.chomp(string, "\n");
    }

    public static String chomp(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String chompLast(String string) {
        return StringUtils.chompLast(string, "\n");
    }

    public static String chompLast(String string, String string2) {
        if (string.length() == 0) {
            return string;
        }
        String string3 = string.substring(string.length() - string2.length());
        if (string2.equals(string3)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String chop(String string) {
        if ("".equals(string)) {
            return "";
        }
        if (string.length() == 1) {
            return "";
        }
        int n = string.length() - 1;
        String string2 = string.substring(0, n);
        char c = string.charAt(n);
        if (c == '\n' && string2.charAt(n - 1) == '\r') {
            return string2.substring(0, n - 1);
        }
        return string2;
    }

    public static String chopNewline(String string) {
        int n = string.length() - 1;
        char c = string.charAt(n);
        if (c == '\n') {
            if (string.charAt(n - 1) == '\r') {
                --n;
            }
        } else {
            ++n;
        }
        return string.substring(0, n);
    }

    public static String clean(String string) {
        return string == null ? "" : string.trim();
    }

    public static String concatenate(Object[] objectArray) {
        return StringUtils.join(objectArray, "");
    }

    public static int countMatches(String string, String string2) {
        if (string2.equals("")) {
            return 0;
        }
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n2)) != -1) {
            ++n;
            n2 += string2.length();
        }
        return n;
    }

    public static String defaultString(Object object) {
        return StringUtils.defaultString(object, "");
    }

    public static String defaultString(Object object, String string) {
        return object == null ? string : object.toString();
    }

    public static String deleteWhitespace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                stringBuffer.append(string.charAt(n2));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String difference(String string, String string2) {
        int n = StringUtils.differenceAt(string, string2);
        if (n == -1) {
            return "";
        }
        return string2.substring(n);
    }

    public static int differenceAt(String string, String string2) {
        int n = 0;
        while (n < string.length() && n < string2.length()) {
            if (string.charAt(n) != string2.charAt(n)) break;
            ++n;
        }
        if (n < string2.length() || n < string.length()) {
            return n;
        }
        return -1;
    }

    public static boolean equals(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return string == null ? string2 == null : string.equalsIgnoreCase(string2);
    }

    public static String escape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c > '\u0fff') {
                stringBuffer.append("\\u" + Integer.toHexString(c));
            } else if (c > '\u00ff') {
                stringBuffer.append("\\u0" + Integer.toHexString(c));
            } else if (c > '\u007f') {
                stringBuffer.append("\\u00" + Integer.toHexString(c));
            } else if (c < ' ') {
                switch (c) {
                    case '\b': {
                        stringBuffer.append('\\');
                        stringBuffer.append('b');
                        break;
                    }
                    case '\n': {
                        stringBuffer.append('\\');
                        stringBuffer.append('n');
                        break;
                    }
                    case '\t': {
                        stringBuffer.append('\\');
                        stringBuffer.append('t');
                        break;
                    }
                    case '\f': {
                        stringBuffer.append('\\');
                        stringBuffer.append('f');
                        break;
                    }
                    case '\r': {
                        stringBuffer.append('\\');
                        stringBuffer.append('r');
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            stringBuffer.append("\\u00" + Integer.toHexString(c));
                            break;
                        }
                        stringBuffer.append("\\u000" + Integer.toHexString(c));
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '\'': {
                        stringBuffer.append('\\');
                        stringBuffer.append('\'');
                        break;
                    }
                    case '\"': {
                        stringBuffer.append('\\');
                        stringBuffer.append('\"');
                        break;
                    }
                    case '\\': {
                        stringBuffer.append('\\');
                        stringBuffer.append('\\');
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        break;
                    }
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getChomp(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n == string.length() - string2.length()) {
            return string2;
        }
        if (n != -1) {
            return string.substring(n);
        }
        return "";
    }

    public static String getNestedString(String string, String string2) {
        return StringUtils.getNestedString(string, string2, string2);
    }

    public static String getNestedString(String string, String string2, String string3) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(string2);
        if (n2 != -1 && (n = string.indexOf(string3, n2 + string2.length())) != -1) {
            return string.substring(n2 + string2.length(), n);
        }
        return null;
    }

    public static String getPrechomp(String string, String string2) {
        int n = string.indexOf(string2);
        if (n != -1) {
            return string.substring(0, n + string2.length());
        }
        return "";
    }

    public static int indexOfAny(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return -1;
        }
        int n = stringArray.length;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n3 = string.indexOf(stringArray[n4]);
            if (n3 != -1 && n3 < n2) {
                n2 = n3;
            }
            ++n4;
        }
        return n2 == Integer.MAX_VALUE ? -1 : n2;
    }

    public static String interpolate(String string, Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            Object v = map.get(string2);
            String string3 = v.toString();
            string = StringUtils.replace(string, "${" + string2 + "}", string3);
            if (string2.indexOf(" ") != -1) continue;
            string = StringUtils.replace(string, "$" + string2, string3);
        }
        return string;
    }

    public static boolean isAlpha(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isLetter(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isAlphaSpace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isLetter(string.charAt(n2)) && string.charAt(n2) != ' ') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isAlphanumeric(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isLetterOrDigit(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isLetterOrDigit(string.charAt(n2)) && string.charAt(n2) != ' ') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isNumeric(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isDigit(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNumericSpace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isDigit(string.charAt(n2)) && string.charAt(n2) != ' ') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isWhitespace(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String join(Iterator iterator, String string) {
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String join(Object[] objectArray, String string) {
        int n;
        if (string == null) {
            string = "";
        }
        int n2 = (n = objectArray.length) == 0 ? 0 : (objectArray[0].toString().length() + string.length()) * n;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n) {
            if (n3 > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(objectArray[n3]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static int lastIndexOfAny(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return -1;
        }
        int n = stringArray.length;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n3 = string.lastIndexOf(stringArray[n4]);
            if (n3 > n2) {
                n2 = n3;
            }
            ++n4;
        }
        return n2;
    }

    public static String left(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Requested String length " + n + " is less than zero");
        }
        if (string == null || string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String leftPad(String string, int n) {
        return StringUtils.leftPad(string, n, " ");
    }

    public static String leftPad(String string, int n, String string2) {
        if ((n = (n - string.length()) / string2.length()) > 0) {
            string = String.valueOf(StringUtils.repeat(string2, n)) + string;
        }
        return string;
    }

    public static String lowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static String lowercaseFirstLetter(String string) {
        String string2 = string.substring(0, 1).toLowerCase();
        String string3 = string.substring(1);
        return String.valueOf(string2) + string3;
    }

    public static String mid(String string, int n, int n2) {
        if (n < 0 || string != null && n > string.length()) {
            throw new StringIndexOutOfBoundsException("String index " + n + " is out of bounds");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Requested String length " + n2 + " is less than zero");
        }
        if (string == null) {
            return null;
        }
        if (string.length() <= n + n2) {
            return string.substring(n);
        }
        return string.substring(n, n + n2);
    }

    public static String overlayString(String string, String string2, int n, int n2) {
        return new StringBuffer(n + string2.length() + string.length() - n2 + 1).append(string.substring(0, n)).append(string2).append(string.substring(n2)).toString();
    }

    public static String prechomp(String string, String string2) {
        int n = string.indexOf(string2);
        if (n != -1) {
            return string.substring(n + string2.length());
        }
        return string;
    }

    public static String removeAndHump(String string, String string2) {
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        string3 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = (String)stringTokenizer.nextElement();
            stringBuffer.append(StringUtils.capitalizeFirstLetter(string4));
        }
        return stringBuffer.toString();
    }

    public static String repeat(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(n * string.length());
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, char c, char c2) {
        return StringUtils.replace(string, c, c2, -1);
    }

    public static String replace(String string, char c, char c2, int n) {
        return StringUtils.replace(string, String.valueOf(c), String.valueOf(c2), n);
    }

    public static String replace(String string, String string2, String string3) {
        return StringUtils.replace(string, string2, string3, -1);
    }

    public static String replace(String string, String string2, String string3, int n) {
        if (string == null || string2 == null || string3 == null || string2.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n3)).append(string3);
            n2 = n3 + string2.length();
            if (--n == 0) break;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String replaceOnce(String string, char c, char c2) {
        return StringUtils.replace(string, c, c2, 1);
    }

    public static String replaceOnce(String string, String string2, String string3) {
        return StringUtils.replace(string, string2, string3, 1);
    }

    public static String reverse(String string) {
        if (string == null) {
            return null;
        }
        return new StringBuffer(string).reverse().toString();
    }

    private static void reverseArray(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length - 1;
        while (n2 > n) {
            Object object = objectArray[n2];
            objectArray[n2] = objectArray[n];
            objectArray[n] = object;
            --n2;
            ++n;
        }
    }

    public static String reverseDelimitedString(String string, String string2) {
        Object[] objectArray = StringUtils.split(string, string2);
        StringUtils.reverseArray(objectArray);
        return StringUtils.join(objectArray, string2);
    }

    public static String right(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Requested String length " + n + " is less than zero");
        }
        if (string == null || string.length() <= n) {
            return string;
        }
        return string.substring(string.length() - n);
    }

    public static String rightPad(String string, int n) {
        return StringUtils.rightPad(string, n, " ");
    }

    public static String rightPad(String string, int n, String string2) {
        if ((n = (n - string.length()) / string2.length()) > 0) {
            string = String.valueOf(string) + StringUtils.repeat(string2, n);
        }
        return string;
    }

    public static String[] split(String string) {
        return StringUtils.split(string, null, -1);
    }

    public static String[] split(String string, String string2) {
        return StringUtils.split(string, string2, -1);
    }

    public static String[] split(String string, String string2, int n) {
        StringTokenizer stringTokenizer = null;
        stringTokenizer = string2 == null ? new StringTokenizer(string) : new StringTokenizer(string, string2);
        int n2 = stringTokenizer.countTokens();
        if (n > 0 && n2 > n) {
            n2 = n;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (n > 0 && n3 == n2 - 1) {
                String string3 = stringTokenizer.nextToken();
                n4 = string.indexOf(string3, n5);
                stringArray[n3] = string.substring(n4);
                break;
            }
            stringArray[n3] = stringTokenizer.nextToken();
            n4 = string.indexOf(stringArray[n3], n5);
            n5 = n4 + stringArray[n3].length();
            ++n3;
        }
        return stringArray;
    }

    public static String strip(String string) {
        return StringUtils.strip(string, null);
    }

    public static String strip(String string, String string2) {
        string = StringUtils.stripStart(string, string2);
        return StringUtils.stripEnd(string, string2);
    }

    public static String[] stripAll(String[] stringArray) {
        return StringUtils.stripAll(stringArray, null);
    }

    public static String[] stripAll(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = StringUtils.strip(stringArray[n2], string);
            ++n2;
        }
        return stringArray2;
    }

    /*
     * Unable to fully structure code
     */
    public static String stripEnd(String var0, String var1_1) {
        block3: {
            if (var0 == null) {
                return null;
            }
            var2_2 = var0.length();
            if (var1_1 != null) ** GOTO lbl10
            while (var2_2 != 0 && Character.isWhitespace(var0.charAt(var2_2 - 1))) {
                --var2_2;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                --var2_2;
lbl10:
                // 2 sources

                ** while (var2_2 != 0 && var1_1.indexOf((int)var0.charAt((int)(var2_2 - 1))) != -1)
            }
        }
        return var0.substring(0, var2_2);
    }

    /*
     * Unable to fully structure code
     */
    public static String stripStart(String var0, String var1_1) {
        block3: {
            if (var0 == null) {
                return null;
            }
            var2_2 = 0;
            var3_3 = var0.length();
            if (var1_1 != null) ** GOTO lbl11
            while (var2_2 != var3_3 && Character.isWhitespace(var0.charAt(var2_2))) {
                ++var2_2;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                ++var2_2;
lbl11:
                // 2 sources

                ** while (var2_2 != var3_3 && var1_1.indexOf((int)var0.charAt((int)var2_2)) != -1)
            }
        }
        return var0.substring(var2_2);
    }

    public static String substring(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n < 0) {
            n = string.length() + n;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > string.length()) {
            return "";
        }
        return string.substring(n);
    }

    public static String substring(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = string.length() + n2;
        }
        if (n < 0) {
            n = string.length() + n;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (n > n2) {
            return "";
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return string.substring(n, n2);
    }

    public static String swapCase(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = false;
        char c = '\u0000';
        char c2 = '\u0000';
        int n2 = 0;
        while (n2 < n) {
            c = string.charAt(n2);
            c2 = Character.isUpperCase(c) ? Character.toLowerCase(c) : (Character.isTitleCase(c) ? Character.toLowerCase(c) : (Character.isLowerCase(c) ? (bl ? Character.toTitleCase(c) : Character.toUpperCase(c)) : c));
            stringBuffer.append(c2);
            bl = Character.isWhitespace(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static String uncapitalise(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        return new StringBuffer(string.length()).append(Character.toLowerCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    public static String uncapitaliseAllWords(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Character.isWhitespace(c)) {
                stringBuffer.append(c);
                bl = true;
            } else if (bl) {
                stringBuffer.append(Character.toLowerCase(c));
                bl = false;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String upperCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase();
    }
}

