/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public final class IOUtil {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtil() {
    }

    public static void bufferedCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        IOUtil.copy((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
        bufferedOutputStream.flush();
    }

    public static void close(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    public static void close(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {}
    }

    public static void close(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
    }

    public static void close(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {}
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(inputStream2);
        int n2 = ((InputStream)bufferedInputStream).read();
        while (n2 != -1) {
            n = ((InputStream)bufferedInputStream2).read();
            if (n2 != n) {
                return false;
            }
            n2 = ((InputStream)bufferedInputStream).read();
        }
        n = ((InputStream)bufferedInputStream2).read();
        return n == -1;
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtil.copy(inputStream, outputStream, 4096);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static void copy(InputStream inputStream, Writer writer) throws IOException {
        IOUtil.copy(inputStream, writer, 4096);
    }

    public static void copy(InputStream inputStream, Writer writer, int n) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        IOUtil.copy((Reader)inputStreamReader, writer, n);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        IOUtil.copy((Reader)inputStreamReader, writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string, int n) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        IOUtil.copy((Reader)inputStreamReader, writer, n);
    }

    public static void copy(Reader reader, OutputStream outputStream) throws IOException {
        IOUtil.copy(reader, outputStream, 4096);
    }

    public static void copy(Reader reader, OutputStream outputStream, int n) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        IOUtil.copy(reader, (Writer)outputStreamWriter, n);
        outputStreamWriter.flush();
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        IOUtil.copy(reader, writer, 4096);
    }

    public static void copy(Reader reader, Writer writer, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = 0;
        while ((n2 = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n2);
        }
        writer.flush();
    }

    public static void copy(String string, OutputStream outputStream) throws IOException {
        IOUtil.copy(string, outputStream, 4096);
    }

    public static void copy(String string, OutputStream outputStream, int n) throws IOException {
        StringReader stringReader = new StringReader(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        IOUtil.copy((Reader)stringReader, (Writer)outputStreamWriter, n);
        outputStreamWriter.flush();
    }

    public static void copy(String string, Writer writer) throws IOException {
        writer.write(string);
    }

    public static void copy(byte[] byArray, OutputStream outputStream) throws IOException {
        IOUtil.copy(byArray, outputStream, 4096);
    }

    public static void copy(byte[] byArray, OutputStream outputStream, int n) throws IOException {
        outputStream.write(byArray);
    }

    public static void copy(byte[] byArray, Writer writer) throws IOException {
        IOUtil.copy(byArray, writer, 4096);
    }

    public static void copy(byte[] byArray, Writer writer, int n) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        IOUtil.copy((InputStream)byteArrayInputStream, writer, n);
    }

    public static void copy(byte[] byArray, Writer writer, String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        IOUtil.copy((InputStream)byteArrayInputStream, writer, string);
    }

    public static void copy(byte[] byArray, Writer writer, String string, int n) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        IOUtil.copy(byteArrayInputStream, writer, string, n);
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        return IOUtil.toByteArray(inputStream, 4096);
    }

    public static byte[] toByteArray(InputStream inputStream, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtil.copy(inputStream, (OutputStream)byteArrayOutputStream, n);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader) throws IOException {
        return IOUtil.toByteArray(reader, 4096);
    }

    public static byte[] toByteArray(Reader reader, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtil.copy(reader, (OutputStream)byteArrayOutputStream, n);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(String string) throws IOException {
        return IOUtil.toByteArray(string, 4096);
    }

    public static byte[] toByteArray(String string, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtil.copy(string, (OutputStream)byteArrayOutputStream, n);
        return byteArrayOutputStream.toByteArray();
    }

    public static String toString(InputStream inputStream) throws IOException {
        return IOUtil.toString(inputStream, 4096);
    }

    public static String toString(InputStream inputStream, int n) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtil.copy(inputStream, (Writer)stringWriter, n);
        return stringWriter.toString();
    }

    public static String toString(InputStream inputStream, String string) throws IOException {
        return IOUtil.toString(inputStream, string, 4096);
    }

    public static String toString(InputStream inputStream, String string, int n) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtil.copy(inputStream, (Writer)stringWriter, string, n);
        return stringWriter.toString();
    }

    public static String toString(Reader reader) throws IOException {
        return IOUtil.toString(reader, 4096);
    }

    public static String toString(Reader reader, int n) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtil.copy(reader, (Writer)stringWriter, n);
        return stringWriter.toString();
    }

    public static String toString(byte[] byArray) throws IOException {
        return IOUtil.toString(byArray, 4096);
    }

    public static String toString(byte[] byArray, int n) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtil.copy(byArray, (Writer)stringWriter, n);
        return stringWriter.toString();
    }

    public static String toString(byte[] byArray, String string) throws IOException {
        return IOUtil.toString(byArray, string, 4096);
    }

    public static String toString(byte[] byArray, String string, int n) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtil.copy(byArray, (Writer)stringWriter, string, n);
        return stringWriter.toString();
    }
}

