/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastMap
implements Map,
Cloneable,
Serializable {
    private transient EntryImpl[] _entries;
    private transient int _capacity;
    private transient int _mask;
    private transient EntryImpl _poolFirst;
    private transient EntryImpl _mapFirst;
    private transient EntryImpl _mapLast;
    private transient int _size;
    private transient Values _values;
    private transient EntrySet _entrySet;
    private transient KeySet _keySet;

    public FastMap() {
        this.initialize(256);
    }

    public FastMap(int n) {
        this.initialize(n);
    }

    public FastMap(Map map) {
        int n = map instanceof FastMap ? ((FastMap)map).capacity() : map.size();
        this.initialize(n);
        this.putAll(map);
    }

    static /* synthetic */ EntryImpl access$0(FastMap fastMap) {
        return fastMap._mapFirst;
    }

    private void addEntry(Object object, Object object2) {
        EntryImpl entryImpl = this._poolFirst;
        if (entryImpl != null) {
            this._poolFirst = entryImpl._after;
            entryImpl._after = null;
        } else {
            entryImpl = new EntryImpl();
        }
        entryImpl._key = object;
        entryImpl._value = object2;
        int n = FastMap.keyHash(object) & this._mask;
        entryImpl._index = n;
        EntryImpl entryImpl2 = this._entries[n];
        entryImpl._next = entryImpl2;
        if (entryImpl2 != null) {
            entryImpl2._previous = entryImpl;
        }
        this._entries[n] = entryImpl;
        if (this._mapLast != null) {
            entryImpl._before = this._mapLast;
            this._mapLast._after = entryImpl;
        } else {
            this._mapFirst = entryImpl;
        }
        this._mapLast = entryImpl;
        ++this._size;
        this.sizeChanged();
    }

    public int capacity() {
        return this._capacity;
    }

    public void clear() {
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != null) {
            entryImpl._key = null;
            entryImpl._value = null;
            entryImpl._before = null;
            entryImpl._next = null;
            if (entryImpl._previous == null) {
                this._entries[((EntryImpl)entryImpl)._index] = null;
            } else {
                entryImpl._previous = null;
            }
            entryImpl = entryImpl._after;
        }
        if (this._mapLast != null) {
            this._mapLast._after = this._poolFirst;
            this._poolFirst = this._mapFirst;
            this._mapFirst = null;
            this._mapLast = null;
            this._size = 0;
            this.sizeChanged();
        }
    }

    public Object clone() {
        try {
            FastMap fastMap = (FastMap)super.clone();
            fastMap.initialize(this._capacity);
            fastMap.putAll((Map)this);
            return fastMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean containsKey(Object object) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                return true;
            }
            entryImpl = entryImpl._next;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != null) {
            if (object.equals(entryImpl._value)) {
                return true;
            }
            entryImpl = entryImpl._after;
        }
        return false;
    }

    public Set entrySet() {
        return this._entrySet;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() == map.size()) {
                EntryImpl entryImpl = this._mapFirst;
                while (entryImpl != null) {
                    if (!map.entrySet().contains(entryImpl)) {
                        return false;
                    }
                    entryImpl = entryImpl._after;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public Object get(Object object) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                return entryImpl._value;
            }
            entryImpl = entryImpl._next;
        }
        return null;
    }

    public Map.Entry getEntry(Object object) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                return entryImpl;
            }
            entryImpl = entryImpl._next;
        }
        return null;
    }

    public int hashCode() {
        int n = 0;
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != null) {
            n += entryImpl.hashCode();
            entryImpl = entryImpl._after;
        }
        return n;
    }

    private void initialize(int n) {
        int n2 = 16;
        while (n2 < n) {
            n2 <<= 1;
        }
        this._entries = new EntryImpl[n2];
        this._mask = n2 - 1;
        this._capacity = n;
        this._size = 0;
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._keySet = new KeySet();
        this._poolFirst = null;
        this._mapFirst = null;
        this._mapLast = null;
        int n3 = 0;
        while (n3 < n) {
            EntryImpl entryImpl = new EntryImpl();
            entryImpl._after = this._poolFirst;
            this._poolFirst = entryImpl;
            ++n3;
        }
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    private static int keyHash(Object object) {
        int n = object.hashCode();
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    public Set keySet() {
        return this._keySet;
    }

    public Object put(Object object, Object object2) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                Object object3 = entryImpl._value;
                entryImpl._value = object2;
                return object3;
            }
            entryImpl = entryImpl._next;
        }
        this.addEntry(object, object2);
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.addEntry(entry.getKey(), entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        this.initialize(n);
        int n2 = objectInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.addEntry(object, object2);
            ++n3;
        }
    }

    public Object remove(Object object) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                Object object2 = entryImpl._value;
                this.removeEntry(entryImpl);
                return object2;
            }
            entryImpl = entryImpl._next;
        }
        return null;
    }

    private void removeEntry(EntryImpl entryImpl) {
        EntryImpl entryImpl2 = entryImpl._previous;
        EntryImpl entryImpl3 = entryImpl._next;
        if (entryImpl2 != null) {
            entryImpl2._next = entryImpl3;
            entryImpl._previous = null;
        } else {
            this._entries[((EntryImpl)entryImpl)._index] = entryImpl3;
        }
        if (entryImpl3 != null) {
            entryImpl3._previous = entryImpl2;
            entryImpl._next = null;
        }
        EntryImpl entryImpl4 = entryImpl._before;
        EntryImpl entryImpl5 = entryImpl._after;
        if (entryImpl4 != null) {
            entryImpl4._after = entryImpl5;
            entryImpl._before = null;
        } else {
            this._mapFirst = entryImpl5;
        }
        if (entryImpl5 != null) {
            entryImpl5._before = entryImpl4;
        } else {
            this._mapLast = entryImpl4;
        }
        entryImpl._key = null;
        entryImpl._value = null;
        entryImpl._after = this._poolFirst;
        this._poolFirst = entryImpl;
        --this._size;
        this.sizeChanged();
    }

    public void setCapacity(int n) {
        EntryImpl entryImpl;
        int n2;
        if (n > this._capacity) {
            n2 = this._capacity;
            while (n2 < n) {
                entryImpl = new EntryImpl();
                entryImpl._after = this._poolFirst;
                this._poolFirst = entryImpl;
                ++n2;
            }
        } else if (n < this._capacity) {
            n2 = n;
            while (n2 < this._capacity && this._poolFirst != null) {
                entryImpl = this._poolFirst;
                this._poolFirst = entryImpl._after;
                entryImpl._after = null;
                ++n2;
            }
        }
        n2 = 16;
        while (n2 < n) {
            n2 <<= 1;
        }
        if (this._entries.length != n2) {
            this._entries = new EntryImpl[n2];
            this._mask = n2 - 1;
            entryImpl = this._mapFirst;
            while (entryImpl != null) {
                int n3 = FastMap.keyHash(entryImpl._key) & this._mask;
                entryImpl._index = n3;
                entryImpl._previous = null;
                EntryImpl entryImpl2 = this._entries[n3];
                entryImpl._next = entryImpl2;
                if (entryImpl2 != null) {
                    entryImpl2._previous = entryImpl;
                }
                this._entries[n3] = entryImpl;
                entryImpl = entryImpl._after;
            }
        }
        this._capacity = n;
    }

    public int size() {
        return this._size;
    }

    protected void sizeChanged() {
        if (this.size() > this.capacity()) {
            this.setCapacity(this.capacity() * 2);
        }
    }

    public String toString() {
        return this.entrySet().toString();
    }

    public Collection values() {
        return this._values;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this._capacity);
        objectOutputStream.writeInt(this._size);
        int n = 0;
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != null) {
            objectOutputStream.writeObject(entryImpl._key);
            objectOutputStream.writeObject(entryImpl._value);
            ++n;
            entryImpl = entryImpl._after;
        }
        if (n != this._size) {
            throw new IOException("FastMap Corrupted");
        }
    }

    private class Values
    extends AbstractCollection {
        Values() {
        }

        static /* synthetic */ FastMap access$0(Values values) {
            return values.FastMap.this;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object object) {
            return FastMap.this.containsValue(object);
        }

        public Iterator iterator() {
            return new Iterator(this){
                private final /* synthetic */ Values this$1;
                EntryImpl after;
                EntryImpl before;
                {
                    this.this$1 = values;
                    this.after = FastMap.access$0(Values.access$0(values));
                }

                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = EntryImpl.access$3(this.after);
                    return EntryImpl.access$2(this.before);
                }

                public void remove() {
                    FastMap.access$1(Values.access$0(this.this$1), this.before);
                }
            };
        }

        public int size() {
            return FastMap.this._size;
        }
    }

    private class EntrySet
    extends AbstractSet {
        EntrySet() {
        }

        static /* synthetic */ FastMap access$0(EntrySet entrySet) {
            return entrySet.FastMap.this;
        }

        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = FastMap.this.getEntry(entry.getKey());
                return entry.equals(entry2);
            }
            return false;
        }

        public Iterator iterator() {
            return new Iterator(this){
                private final /* synthetic */ EntrySet this$1;
                EntryImpl after;
                EntryImpl before;
                {
                    this.this$1 = entrySet;
                    this.after = FastMap.access$0(EntrySet.access$0(entrySet));
                }

                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = EntryImpl.access$3(this.after);
                    return this.before;
                }

                public void remove() {
                    FastMap.access$1(EntrySet.access$0(this.this$1), this.before);
                }
            };
        }

        public boolean remove(Object object) {
            Map.Entry entry;
            EntryImpl entryImpl;
            if (object instanceof Map.Entry && (entryImpl = (EntryImpl)FastMap.this.getEntry((entry = (Map.Entry)object).getKey())) != null && entry.getValue().equals(entryImpl._value)) {
                FastMap.this.removeEntry(entryImpl);
                return true;
            }
            return false;
        }

        public int size() {
            return FastMap.this._size;
        }
    }

    private class KeySet
    extends AbstractSet {
        KeySet() {
        }

        static /* synthetic */ FastMap access$0(KeySet keySet) {
            return keySet.FastMap.this;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object object) {
            return FastMap.this.containsKey(object);
        }

        public Iterator iterator() {
            return new Iterator(this){
                private final /* synthetic */ KeySet this$1;
                EntryImpl after;
                EntryImpl before;
                {
                    this.this$1 = keySet;
                    this.after = FastMap.access$0(KeySet.access$0(keySet));
                }

                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = EntryImpl.access$3(this.after);
                    return EntryImpl.access$0(this.before);
                }

                public void remove() {
                    FastMap.access$1(KeySet.access$0(this.this$1), this.before);
                }
            };
        }

        public boolean remove(Object object) {
            return FastMap.this.remove(object) != null;
        }

        public int size() {
            return FastMap.this._size;
        }
    }

    private static final class EntryImpl
    implements Map.Entry {
        private Object _key;
        private Object _value;
        private int _index;
        private EntryImpl _previous;
        private EntryImpl _next;
        private EntryImpl _before;
        private EntryImpl _after;

        EntryImpl() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) return false;
            Map.Entry entry = (Map.Entry)object;
            if (!this._key.equals(entry.getKey())) return false;
            if (this._value == null) {
                if (entry.getValue() == null) return true;
                return false;
            }
            boolean bl = this._value.equals(entry.getValue());
            if (bl) return true;
            return false;
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public int hashCode() {
            return this._key.hashCode() ^ (this._value != null ? this._value.hashCode() : 0);
        }

        public Object setValue(Object object) {
            Object object2 = this._value;
            this._value = object;
            return object2;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this._key)) + "=" + this._value;
        }
    }
}

