/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class ExceptionUtils {
    static final String WRAPPED_MARKER = " [wrapped] ";
    protected static String[] CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested"};
    static /* synthetic */ Class class$java$lang$Throwable;

    protected ExceptionUtils() {
    }

    public static void addCauseMethodName(String string) {
        if (string != null && string.length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(CAUSE_METHOD_NAMES));
            arrayList.add(string);
            CAUSE_METHOD_NAMES = arrayList.toArray(new String[arrayList.size()]);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Throwable getCause(Throwable throwable) {
        return ExceptionUtils.getCause(throwable, CAUSE_METHOD_NAMES);
    }

    public static Throwable getCause(Throwable throwable, String[] stringArray) {
        Throwable throwable2 = ExceptionUtils.getCauseUsingWellKnownTypes(throwable);
        if (throwable2 == null) {
            int n = 0;
            while (n < stringArray.length) {
                throwable2 = ExceptionUtils.getCauseUsingMethodName(throwable, stringArray[n]);
                if (throwable2 != null) break;
                ++n;
            }
            if (throwable2 == null) {
                throwable2 = ExceptionUtils.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return throwable2;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String string) {
        Field field = null;
        try {
            field = throwable.getClass().getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {}
        if (field != null && (class$java$lang$Throwable != null ? class$java$lang$Throwable : (class$java$lang$Throwable = ExceptionUtils.class$("java.lang.Throwable"))).isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String string) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(string, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {}
        if (method != null && (class$java$lang$Throwable != null ? class$java$lang$Throwable : (class$java$lang$Throwable = ExceptionUtils.class$("java.lang.Throwable"))).isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
        }
        return null;
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    public static String getFullStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        Throwable[] throwableArray = ExceptionUtils.getThrowables(throwable);
        int n = 0;
        while (n < throwableArray.length) {
            throwableArray[n].printStackTrace(printWriter);
            if (ExceptionUtils.isNestedThrowable(throwableArray[n])) break;
            ++n;
        }
        return stringWriter.getBuffer().toString();
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2 = ExceptionUtils.getCause(throwable);
        if (throwable2 != null) {
            throwable = throwable2;
            while ((throwable = ExceptionUtils.getCause(throwable)) != null) {
                throwable2 = throwable;
            }
        }
        return throwable2;
    }

    public static String[] getRootCauseStackTrace(Throwable throwable) {
        Throwable[] throwableArray = ExceptionUtils.getThrowables(throwable);
        int n = throwableArray.length;
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = ExceptionUtils.getStackFrameList(throwableArray[n - 1]);
        int n2 = n;
        while (--n2 >= 0) {
            List list2 = list;
            if (n2 != 0) {
                list = ExceptionUtils.getStackFrameList(throwableArray[n2 - 1]);
                ExceptionUtils.removeCommonFrames(list2, list);
            }
            if (n2 == n - 1) {
                arrayList.add(throwableArray[n2].toString());
            } else {
                arrayList.add(WRAPPED_MARKER + throwableArray[n2].toString());
            }
            int n3 = 0;
            while (n3 < list2.size()) {
                arrayList.add((String)list2.get(n3));
                ++n3;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    static List getStackFrameList(Throwable throwable) {
        String string = ExceptionUtils.getStackTrace(throwable);
        String string2 = System.getProperty("line.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf("at");
            if (n != -1 && string3.substring(0, n).trim().length() == 0) {
                bl = true;
                linkedList.add(string3);
                continue;
            }
            if (bl) break;
        }
        return linkedList;
    }

    static String[] getStackFrames(String string) {
        String string2 = System.getProperty("line.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        return linkedList.toArray(new String[0]);
    }

    public static String[] getStackFrames(Throwable throwable) {
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(throwable));
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    public static int getThrowableCount(Throwable throwable) {
        int n = 0;
        while (throwable != null) {
            ++n;
            throwable = ExceptionUtils.getCause(throwable);
        }
        return n;
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        while (throwable != null) {
            arrayList.add(throwable);
            throwable = ExceptionUtils.getCause(throwable);
        }
        return arrayList.toArray(new Throwable[arrayList.size()]);
    }

    public static int indexOfThrowable(Throwable throwable, Class clazz) {
        return ExceptionUtils.indexOfThrowable(throwable, clazz, 0);
    }

    public static int indexOfThrowable(Throwable throwable, Class clazz, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Throwable index out of range: " + n);
        }
        Throwable[] throwableArray = ExceptionUtils.getThrowables(throwable);
        if (n >= throwableArray.length) {
            throw new IndexOutOfBoundsException("Throwable index out of range: " + n);
        }
        int n2 = n;
        while (n2 < throwableArray.length) {
            if (throwableArray[n2].getClass().equals(clazz)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static boolean isNestedThrowable(Throwable throwable) {
        AccessibleObject accessibleObject;
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException) {
            return true;
        }
        if (throwable instanceof InvocationTargetException) {
            return true;
        }
        int n = CAUSE_METHOD_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                accessibleObject = throwable.getClass().getMethod(CAUSE_METHOD_NAMES[n2], null);
                if (accessibleObject != null) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {}
            ++n2;
        }
        try {
            accessibleObject = throwable.getClass().getField("detail");
            if (accessibleObject != null) {
                return true;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {}
        return false;
    }

    public static void printRootCauseStackTrace(Throwable throwable) {
        ExceptionUtils.printRootCauseStackTrace(throwable, System.err);
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintStream printStream) {
        String[] stringArray = ExceptionUtils.getRootCauseStackTrace(throwable);
        int n = 0;
        while (n < stringArray.length) {
            printStream.println(stringArray[n]);
            ++n;
        }
        printStream.flush();
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintWriter printWriter) {
        String[] stringArray = ExceptionUtils.getRootCauseStackTrace(throwable);
        int n = 0;
        while (n < stringArray.length) {
            printWriter.println(stringArray[n]);
            ++n;
        }
        printWriter.flush();
    }

    private static void removeCommonFrames(List list, List list2) {
        int n = list.size() - 1;
        int n2 = list2.size() - 1;
        while (n >= 0 && n2 >= 0) {
            String string;
            String string2 = (String)list.get(n);
            if (string2.equals(string = (String)list2.get(n2))) {
                list.remove(n);
            }
            --n;
            --n2;
        }
    }
}

