/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.plexus.summit.parameters.RequestParameters;
import org.codehaus.plexus.summit.rundata.RunData;

public class UriBuilder {
    public static final String ROLE = (class$org$codehaus$plexus$summit$util$UriBuilder != null ? class$org$codehaus$plexus$summit$util$UriBuilder : (class$org$codehaus$plexus$summit$util$UriBuilder = UriBuilder.class$("org.codehaus.plexus.summit.util.UriBuilder"))).getName();
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final int ANCHOR_STATIC_PART_LENGTH = "<a href=\"\"></a>".length();
    protected RunData data = null;
    public HttpServletResponse res = null;
    protected ArrayList pathInfo = new ArrayList();
    protected ArrayList queryData = new ArrayList();
    protected boolean redirect = false;
    protected static final int PATH_INFO = 0;
    protected static final int QUERY_DATA = 1;
    private boolean isRelative = false;
    private boolean encodeUrl = true;
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static boolean[] safe = new boolean[128];
    static /* synthetic */ Class class$org$codehaus$plexus$summit$util$UriBuilder;

    static {
        int n = 97;
        while (n <= 122) {
            UriBuilder.safe[n] = true;
            ++n;
        }
        int n2 = 65;
        while (n2 <= 90) {
            UriBuilder.safe[n2] = true;
            ++n2;
        }
        int n3 = 48;
        while (n3 <= 57) {
            UriBuilder.safe[n3] = true;
            ++n3;
        }
        UriBuilder.safe[45] = true;
        UriBuilder.safe[95] = true;
        UriBuilder.safe[46] = true;
        UriBuilder.safe[33] = true;
        UriBuilder.safe[126] = true;
        UriBuilder.safe[42] = true;
        UriBuilder.safe[39] = true;
        UriBuilder.safe[40] = true;
        UriBuilder.safe[41] = true;
    }

    public UriBuilder() {
    }

    public UriBuilder(RunData runData) {
        this.init(runData);
    }

    protected void add(int n, String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        if (n == 0) {
            this.pathInfo.add(objectArray);
        } else if (n == 1) {
            this.queryData.add(objectArray);
        }
    }

    protected void add(int n, RequestParameters requestParameters) {
        if (n == 0) {
            this.add(this.pathInfo, requestParameters);
        } else if (n == 1) {
            this.add(this.queryData, requestParameters);
        }
    }

    protected void add(ArrayList arrayList, RequestParameters requestParameters) {
        Iterator iterator = requestParameters.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equalsIgnoreCase("action") || string.equalsIgnoreCase("target")) continue;
            String[] stringArray = requestParameters.getStrings(string);
            int n = 0;
            while (n < stringArray.length) {
                this.addPair(arrayList, string, stringArray[n]);
                ++n;
            }
        }
    }

    protected void addPair(ArrayList arrayList, String string, String string2) {
        Object[] objectArray = new Object[]{string, string2};
        arrayList.add(objectArray);
    }

    public UriBuilder addPathInfo(String string, double d) {
        this.addPathInfo(string, Double.toString(d));
        return this;
    }

    public UriBuilder addPathInfo(String string, int n) {
        this.addPathInfo(string, new Integer(n).toString());
        return this;
    }

    public UriBuilder addPathInfo(String string, long l) {
        this.addPathInfo(string, new Long(l).toString());
        return this;
    }

    public UriBuilder addPathInfo(String string, Object object) {
        this.addPathInfo(string, object.toString());
        return this;
    }

    public UriBuilder addPathInfo(String string, String string2) {
        this.addPair(this.pathInfo, string, string2);
        return this;
    }

    public UriBuilder addPathInfo(String string, boolean bl) {
        this.addPathInfo(string, bl ? "true" : "false");
        return this;
    }

    public UriBuilder addPathInfo(RequestParameters requestParameters) {
        this.add(this.pathInfo, requestParameters);
        return this;
    }

    public UriBuilder addQueryData(String string, double d) {
        this.addQueryData(string, Double.toString(d));
        return this;
    }

    public UriBuilder addQueryData(String string, int n) {
        this.addQueryData(string, new Integer(n).toString());
        return this;
    }

    public UriBuilder addQueryData(String string, long l) {
        this.addQueryData(string, new Long(l).toString());
        return this;
    }

    public UriBuilder addQueryData(String string, Object object) {
        this.addQueryData(string, object.toString());
        return this;
    }

    public UriBuilder addQueryData(String string, String string2) {
        this.addPair(this.queryData, string, string2);
        return this;
    }

    public UriBuilder addQueryData(RequestParameters requestParameters) {
        this.add(this.queryData, requestParameters);
        return this;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getA(String string) {
        String string2 = this.toString();
        int n = ANCHOR_STATIC_PART_LENGTH + string2.length() + string.length();
        return new StringBuffer(n).append("<a href=\"").append(string2).append("\">").append(string).append("</a>").toString();
    }

    public String getScriptName() {
        return this.data.getScriptName();
    }

    public String getServerName() {
        return this.data.getServerName();
    }

    public int getServerPort() {
        return this.data.getServerPort();
    }

    public String getServerScheme() {
        return this.data.getServerScheme();
    }

    public boolean hasPathInfo() {
        return this.pathInfo.isEmpty() ^ true;
    }

    public boolean hasQueryData() {
        return this.queryData.isEmpty() ^ true;
    }

    public void init() {
        this.pathInfo.clear();
        this.queryData.clear();
    }

    public void init(RunData runData) {
        this.data = runData;
        this.res = this.data.getResponse();
        this.init();
    }

    public boolean isEncodeUrl() {
        return this.encodeUrl;
    }

    public boolean isRelative() {
        return this.isRelative;
    }

    protected void remove(int n, String string) {
        try {
            if (n == 0) {
                this.removePathInfo(string);
            } else if (n == 1) {
                this.removeQueryData(string);
            }
        }
        catch (Exception exception) {}
    }

    protected void removePairByName(ArrayList arrayList, String string) {
        int n = 0;
        while (n < arrayList.size()) {
            Object[] objectArray = (Object[])arrayList.get(n);
            if (string.equals((String)objectArray[0])) {
                arrayList.remove(n);
            }
            ++n;
        }
    }

    public void removePathInfo() {
        this.pathInfo.clear();
    }

    public void removePathInfo(String string) {
        this.removePairByName(this.pathInfo, string);
    }

    public void removeQueryData() {
        this.queryData.clear();
    }

    public void removeQueryData(String string) {
        this.removePairByName(this.queryData, string);
    }

    protected void renderPairs(ArrayList arrayList, StringBuffer stringBuffer, char c, char c2) {
        boolean bl = true;
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = (Object[])arrayList.get(n2);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(c);
            }
            UriBuilder.writeFastEncoded((String)objectArray[0], stringBuffer);
            stringBuffer.append(c2);
            UriBuilder.writeFastEncoded((String)objectArray[1], stringBuffer);
            ++n2;
        }
    }

    protected void renderPathInfo(ArrayList arrayList, StringBuffer stringBuffer) {
        this.renderPairs(arrayList, stringBuffer, '/', '/');
    }

    protected String renderPathInfo(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        this.renderPathInfo(new ArrayList(vector), stringBuffer);
        return stringBuffer.toString();
    }

    protected void renderQueryString(ArrayList arrayList, StringBuffer stringBuffer) {
        this.renderPairs(arrayList, stringBuffer, '&', '=');
    }

    protected String renderQueryString(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        this.renderQueryString(new ArrayList(vector), stringBuffer);
        return stringBuffer.toString();
    }

    public UriBuilder setAction(String string) {
        this.addPathInfo("action", string);
        return this;
    }

    public UriBuilder setEncodeUrl(boolean bl) {
        this.encodeUrl = bl;
        return this;
    }

    public UriBuilder setRedirect(boolean bl) {
        this.redirect = bl;
        return this;
    }

    public UriBuilder setRelative(boolean bl) {
        this.isRelative = bl;
        return this;
    }

    public UriBuilder setTarget(String string) {
        this.addPathInfo("target", string);
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isRelative()) {
            stringBuffer.append(this.data.getServerScheme());
            stringBuffer.append("://");
            stringBuffer.append(this.data.getServerName());
            if (this.data.getServerScheme().equals(HTTP) && this.data.getServerPort() != 80 || this.data.getServerScheme().equals(HTTPS) && this.data.getServerPort() != 443) {
                stringBuffer.append(':');
                stringBuffer.append(this.data.getServerPort());
            }
        }
        stringBuffer.append(this.data.getContextPath());
        stringBuffer.append(this.data.getScriptName());
        if (this.hasPathInfo()) {
            stringBuffer.append('/');
            this.renderPathInfo(this.pathInfo, stringBuffer);
        }
        if (this.hasQueryData()) {
            stringBuffer.append('?');
            this.renderQueryString(this.queryData, stringBuffer);
        }
        if (this.res != null && this.isEncodeUrl()) {
            if (this.redirect) {
                return this.res.encodeRedirectURL(stringBuffer.toString());
            }
            return this.res.encodeURL(stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public static String toString(RunData runData) {
        return UriBuilder.toString(runData, true);
    }

    public static String toString(RunData runData, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(128);
        HttpServletRequest httpServletRequest = runData.getRequest();
        if (bl) {
            stringBuffer.append(runData.getServerScheme());
            stringBuffer.append("://");
            stringBuffer.append(runData.getServerName());
            if (runData.getServerScheme().equals(HTTP) && runData.getServerPort() != 80 || runData.getServerScheme().equals(HTTPS) && runData.getServerPort() != 443) {
                stringBuffer.append(':');
                stringBuffer.append(runData.getServerPort());
            }
        }
        stringBuffer.append(runData.getContextPath());
        stringBuffer.append(runData.getScriptName());
        if (httpServletRequest.getPathInfo() != null) {
            stringBuffer.append(httpServletRequest.getPathInfo());
        }
        if (httpServletRequest.getQueryString() != null) {
            stringBuffer.append('?');
            stringBuffer.append(httpServletRequest.getQueryString());
        }
        return stringBuffer.toString();
    }

    protected static final void writeEncoded(String string, StringBuffer stringBuffer) {
        if (string == null || string.length() == 0) {
            stringBuffer.append("null");
            return;
        }
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < byArray.length) {
            char c = (char)byArray[n];
            if (c < '\u0080' && safe[c]) {
                stringBuffer.append(c);
            } else if (c == ' ') {
                stringBuffer.append('+');
            } else {
                byte by = byArray[n];
                stringBuffer.append('%');
                int n2 = by & 0xF;
                int n3 = (by & 0xF0) >> 4;
                stringBuffer.append(hexadecimal[n3]);
                stringBuffer.append(hexadecimal[n2]);
            }
            ++n;
        }
    }

    protected static final void writeFastEncoded(String string, StringBuffer stringBuffer) {
        if (string == null || string.length() == 0) {
            stringBuffer.append("null");
            return;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c < '\u0080' && safe[c]) {
                stringBuffer.append(c);
            } else if (c == ' ') {
                stringBuffer.append('+');
            } else {
                UriBuilder.writeEncoded(new String(cArray, n, cArray.length - n), stringBuffer);
                break;
            }
            ++n;
        }
    }
}

