/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.resolver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.summit.module.Module;
import org.codehaus.plexus.summit.resolver.AbstractResolver;
import org.codehaus.plexus.summit.resolver.Resolution;
import org.codehaus.plexus.summit.resolver.ResolverUtils;
import org.codehaus.plexus.summit.view.View;

public class ClassicResolver
extends AbstractResolver {
    private List modulePackages = new ArrayList();
    private StringBuffer modulePackagesNames;
    public static final String DEFAULT_LAYOUT_MODULE = "Default";
    public static final String DEFAULT_LAYOUT_MODULE_KEY = "defaultLayoutModule";
    public static final String DEFAULT_NAV_MODULE = "Default";
    public static final String DEFAULT_NAV_MODULE_KEY = "defaultLayoutModule";
    public static final String DEFAULT_SCREEN_MODULE = "Default";
    public static final String DEFAULT_SCREEN_MODULE_KEY = "defaultLayoutModule";
    public static final String LAYOUT_MODULE = "layoutModule";
    public static final String LAYOUT_VIEW = "layoutView";
    public static final String NAVIGATION_MODULE = "navigationModule";
    public static final String NAVIGATION_VIEW = "navigationView";
    public static final String SCREEN_MODULE = "screenModule";
    public static final String SCREEN_VIEW = "screenView";
    private static final String LAYOUT_TARGET_PREFIX = "layouts";
    private static final String NAVIGATION_TARGET_PREFIX = "navigations";
    private static final String SCREEN_TARGET_PREFIX = "screens";
    private String defaultLayoutModule;
    private String defaultNavigationModule;
    private String defaultScreenModule;

    public ClassicResolver() {
        this.modulePackages.add("");
        this.modulePackagesNames = new StringBuffer();
    }

    void addModulePackage(String string) {
        this.modulePackages.add(string);
        this.modulePackagesNames.append(string).append("\n");
    }

    public void clearModulePackages() {
        int n = this.modulePackages.size();
        int n2 = 0;
        while (n2 < n) {
            this.modulePackages.remove(0);
            ++n2;
        }
    }

    public String getDefaultLayoutModule() {
        return this.defaultLayoutModule;
    }

    public String getDefaultNavigationModule() {
        return this.defaultNavigationModule;
    }

    public String getDefaultScreenModule() {
        return this.defaultScreenModule;
    }

    protected Module getLayoutModule(String string) throws Exception {
        return this.getModule(string, LAYOUT_TARGET_PREFIX, this.getDefaultLayoutModule());
    }

    Module getModule(String string) throws Exception {
        return this.getModule(string, null, null);
    }

    Module getModule(String string, String string2) throws Exception {
        return this.getModule(string, string2, null);
    }

    Module getModule(String string, String string2, String string3) throws Exception {
        Module module = null;
        List list = this.getPossibleModules(string, string2);
        if (string3 != null && string3.length() > 0) {
            list.add(string3);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            try {
                this.getLogger().debug("[Resolver] Looking for " + string4);
                module = (Module)Class.forName(string4).newInstance();
                this.getLogger().debug("[Resolver] " + string + " => " + string4);
                break;
            }
            catch (Exception exception) {}
        }
        return module;
    }

    public List getModulePackages() {
        return this.modulePackages;
    }

    protected Module getNavigationModule(String string) throws Exception {
        return this.getModule(string, NAVIGATION_TARGET_PREFIX, this.getDefaultNavigationModule());
    }

    List getPossibleModules(String string, String string2) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = ResolverUtils.getPossibleModuleSuffixes(string, this.getDefaultBaseName());
        Iterator iterator = this.modulePackages.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string4 = string2 != null && string2.length() > 0 ? String.valueOf(string3) + "." + string2 + "." + iterator2.next() : String.valueOf(string3) + "." + iterator2.next();
                arrayList.add(string4);
            }
        }
        return arrayList;
    }

    protected Module getScreenModule(String string) throws Exception {
        return this.getModule(string, SCREEN_TARGET_PREFIX, this.getDefaultScreenModule());
    }

    public Resolution resolve(String string) throws Exception {
        Resolution resolution = new Resolution();
        Module module = this.getLayoutModule(string);
        resolution.put(LAYOUT_MODULE, module);
        View view = this.getView(string, LAYOUT_TARGET_PREFIX);
        resolution.put(LAYOUT_VIEW, view);
        Module module2 = this.getNavigationModule(string);
        resolution.put(NAVIGATION_MODULE, module2);
        View view2 = this.getView(string, NAVIGATION_TARGET_PREFIX);
        resolution.put(NAVIGATION_VIEW, view2);
        Module module3 = this.getScreenModule(string);
        resolution.put(SCREEN_MODULE, module3);
        View view3 = this.getView(string, SCREEN_TARGET_PREFIX);
        resolution.put(SCREEN_VIEW, view3);
        return resolution;
    }

    public void setDefaultLayoutModule(String string) {
        this.defaultLayoutModule = string;
    }

    public void setDefaultNavigationModule(String string) {
        this.defaultNavigationModule = string;
    }

    public void setDefaultScreenModule(String string) {
        this.defaultScreenModule = string;
    }

    void setModulePackages(List list) {
        this.modulePackages = list;
    }
}

