/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.pull;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.summit.pull.PullService;
import org.codehaus.plexus.summit.pull.RequestTool;
import org.codehaus.plexus.summit.pull.Tool;
import org.codehaus.plexus.summit.rundata.RunData;
import org.codehaus.plexus.summit.view.ViewContext;

public class DefaultPullService
extends AbstractLogEnabled
implements PullService,
Contextualizable,
Initializable,
Disposable {
    public static final String GLOBAL_SCOPE = "global";
    public static final String REQUEST_SCOPE = "request";
    public static final String SESSION_SCOPE = "session";
    private Map globalTools = new HashMap();
    private Map sessionTools = new HashMap();
    private Map requestTools = new HashMap();
    private PlexusContainer container;
    private List tools;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public void dispose() {
        try {
            this.disposeGlobalTools();
        }
        catch (Exception exception) {
            this.getLogger().error("Problem disposing global tools: ", (Throwable)exception);
        }
        this.container = null;
    }

    private void disposeGlobalTools() throws Exception {
        Iterator iterator = this.globalTools.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.container.release(this.globalTools.remove(string));
        }
    }

    public void initialize() throws Exception {
        Iterator iterator = this.tools.iterator();
        while (iterator.hasNext()) {
            Tool tool = (Tool)iterator.next();
            if (tool.getScope().equals(GLOBAL_SCOPE)) {
                Object object = this.container.lookup(tool.getRole());
                this.globalTools.put(tool.getName(), object);
                continue;
            }
            if (tool.getScope().equals(REQUEST_SCOPE)) {
                this.requestTools.put(tool.getName(), tool.getRole());
                continue;
            }
            if (!tool.getScope().equals(SESSION_SCOPE)) continue;
            this.sessionTools.put(tool.getName(), tool.getRole());
        }
    }

    public void populateContext(ViewContext viewContext, RunData runData) {
        this.populateWithGlobalTools(viewContext);
        this.populateWithRequestTools(viewContext, runData);
        this.populateWithSessionTools(viewContext, runData);
    }

    protected void populateWithGlobalTools(ViewContext viewContext) {
        viewContext.putAll(this.globalTools);
    }

    protected void populateWithRequestTools(ViewContext viewContext, RunData runData) {
        Iterator iterator = this.requestTools.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Object object = this.container.lookup((String)this.requestTools.get(string));
                this.setRequestRunData(object, runData);
                viewContext.put(string, object);
                this.getLogger().debug("Addded tool $" + string + " to the context.");
            }
            catch (Exception exception) {
                this.getLogger().error("Couldn't find request tool " + string + " with role " + this.requestTools.get(string) + ".", (Throwable)exception);
            }
        }
    }

    protected void populateWithSessionTools(ViewContext viewContext, RunData runData) {
        Iterator iterator = this.sessionTools.keySet().iterator();
        while (iterator.hasNext()) {
            HttpSession httpSession;
            String string = (String)iterator.next();
            HttpSession httpSession2 = httpSession = runData.getSession();
            synchronized (httpSession2) {
                Object object = httpSession.getAttribute(string);
                if (object == null) {
                    try {
                        object = this.container.lookup((String)this.sessionTools.get(string));
                        httpSession.setAttribute(string, object);
                    }
                    catch (Exception exception) {
                        this.getLogger().error("Could find request tool " + string + " with role " + this.sessionTools.get(string) + ".", (Throwable)exception);
                        Object var7_9 = null;
                        break;
                    }
                }
                viewContext.put(string, object);
                this.getLogger().debug("Addded tool $" + string + " to the context.");
            }
        }
    }

    public void releaseTools(ViewContext viewContext) {
        try {
            this.releaseTools(viewContext, this.requestTools);
        }
        catch (Exception exception) {
            this.getLogger().error("Problem releasing tools: ", (Throwable)exception);
        }
    }

    protected void releaseTools(ViewContext viewContext, Map map) throws Exception {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = viewContext.remove(string);
            this.container.release(object);
        }
    }

    protected void setRequestRunData(Object object, RunData runData) {
        if (object instanceof RequestTool) {
            ((RequestTool)object).setRunData(runData);
        }
    }
}

