/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.parameters;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.summit.parameters.RequestParameterParser;
import org.codehaus.plexus.summit.parameters.RequestParameters;

public class BaseRequestParameterParser
extends AbstractLogEnabled
implements RequestParameterParser,
Initializable {
    private FileUpload fileUpload = new FileUpload();
    private int maxUploadSize;
    private int maxMemorySize;
    private String tempDirectory;
    private String defaultEncoding = "US-ASCII";

    protected void addFileItem(Map map, String string, FileItem fileItem) {
        FileItem[] fileItemArray = (FileItem[])map.get(string);
        if (fileItemArray == null) {
            fileItemArray = new FileItem[]{fileItem};
            map.put(string, fileItemArray);
        } else {
            FileItem[] fileItemArray2 = new FileItem[fileItemArray.length + 1];
            System.arraycopy(fileItemArray, 0, fileItemArray2, 0, fileItemArray.length);
            fileItemArray2[fileItemArray.length] = fileItem;
            map.put(string, fileItemArray2);
        }
    }

    protected void addParameter(Map map, String string, String string2) {
        String[] stringArray = (String[])map.get(string);
        if (stringArray == null) {
            stringArray = new String[]{string2};
            map.put(string, stringArray);
        } else {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string2;
            map.put(string, stringArray2);
        }
    }

    protected void doParse(HttpServletRequest httpServletRequest, Map map) {
    }

    private String getFormField(FileItem fileItem, String string) {
        String string2 = null;
        try {
            string2 = fileItem.getString(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = fileItem.getString();
            this.getLogger().error("Unsupported encoding, used default");
        }
        return string2;
    }

    public void initialize() throws Exception {
        this.fileUpload.setSizeMax(this.maxUploadSize);
        this.fileUpload.setSizeThreshold(this.maxMemorySize);
        this.fileUpload.setRepositoryPath(this.tempDirectory);
    }

    public RequestParameters parse(HttpServletRequest httpServletRequest) {
        String string;
        HashMap hashMap = new HashMap();
        String string2 = string = httpServletRequest.getCharacterEncoding() == null ? this.defaultEncoding : httpServletRequest.getCharacterEncoding();
        if (FileUpload.isMultipartContent((HttpServletRequest)httpServletRequest)) {
            this.processFileUploadItems(httpServletRequest, hashMap, string);
        }
        this.processQueryInfo(httpServletRequest, hashMap);
        this.doParse(httpServletRequest, hashMap);
        return new RequestParameters(hashMap, string);
    }

    private void processFileUploadItems(HttpServletRequest httpServletRequest, Map map, String string) {
        try {
            List list = this.fileUpload.parseRequest(httpServletRequest);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FileItem fileItem = (FileItem)iterator.next();
                if (fileItem.isFormField()) {
                    this.addParameter(map, fileItem.getFieldName(), this.getFormField(fileItem, string));
                    continue;
                }
                this.addFileItem(map, fileItem.getFieldName(), fileItem);
            }
        }
        catch (FileUploadException fileUploadException) {
            this.getLogger().error("FileUpload failed", (Throwable)fileUploadException);
        }
    }

    private void processQueryInfo(HttpServletRequest httpServletRequest, Map map) {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            map.put(string, httpServletRequest.getParameterValues(string));
        }
    }
}

