/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.parameters;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.plexus.summit.parameters.ParameterConverter;

public class BaseParameterConverter
implements ParameterConverter {
    protected Map parameters;
    protected String characterEncoding = "US-ASCII";

    public BaseParameterConverter(Map map) {
        this(map, null);
    }

    public BaseParameterConverter(Map map, String string) {
        if (map == null) {
            throw new NullPointerException("parameter map is null");
        }
        if (string != null) {
            this.characterEncoding = string;
        }
        this.parameters = map;
    }

    public boolean containsKey(Object object) {
        return this.parameters.containsKey(object);
    }

    public String get(String string) {
        return this.getString(string);
    }

    public BigDecimal getBigDecimal(String string) {
        return this.getBigDecimal(string, new BigDecimal(0.0));
    }

    public BigDecimal getBigDecimal(String string, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal;
        try {
            String string2;
            Object v = this.parameters.get(string);
            if (v != null && (string2 = ((String[])v)[0]).length() > 0) {
                bigDecimal2 = new BigDecimal(((String[])v)[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return bigDecimal2;
    }

    public BigDecimal[] getBigDecimals(String string) {
        BigDecimal[] bigDecimalArray = null;
        String[] stringArray = this.getStrings(string);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            bigDecimalArray = new BigDecimal[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                bigDecimalArray[n] = new BigDecimal(stringArray2[n]);
                ++n;
            }
        }
        return bigDecimalArray;
    }

    public Boolean getBool(String string) {
        return new Boolean(this.getBoolean(string, false));
    }

    public Boolean getBool(String string, boolean bl) {
        return new Boolean(this.getBoolean(string, bl));
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        Object v = this.parameters.get(string);
        if (v != null) {
            String string2 = this.getString(string);
            if (string2.equalsIgnoreCase("1") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("on")) {
                bl2 = true;
            }
            if (string2.equalsIgnoreCase("0") || string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("off")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public byte getByte(String string) {
        return this.getByte(string, (byte)0);
    }

    public byte getByte(String string, byte by) {
        byte by2 = by;
        try {
            Object v = this.parameters.get(string);
            if (v != null) {
                by2 = Byte.valueOf(((String[])v)[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return by2;
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        String string2 = this.getString(string);
        if (string2 != null) {
            return string2.getBytes(this.characterEncoding);
        }
        return null;
    }

    public Date getDate(String string) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        return this.getDate(string, dateFormat, null);
    }

    public Date getDate(String string, DateFormat dateFormat) {
        return this.getDate(string, dateFormat, null);
    }

    public Date getDate(String string, DateFormat dateFormat, Date date) {
        Date date2 = null;
        if (this.containsKey(string)) {
            try {
                dateFormat.setLenient(false);
                date2 = dateFormat.parse(this.getString(string));
            }
            catch (ParseException parseException) {
                date2 = date;
            }
        } else {
            date2 = date;
        }
        return date2;
    }

    public double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    public double getDouble(String string, double d) {
        double d2 = d;
        try {
            Object v = this.parameters.get(string);
            if (v != null) {
                d2 = Double.valueOf(((String[])v)[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return d2;
    }

    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloat(String string, float f) {
        float f2 = f;
        try {
            Object v = this.parameters.get(string);
            if (v != null) {
                f2 = Float.valueOf(((String[])v)[0]).floatValue();
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return f2;
    }

    public int getInt(String string) {
        return this.getInt(string, 0);
    }

    public int getInt(String string, int n) {
        int n2 = n;
        try {
            Object v = this.parameters.get(string);
            if (v != null) {
                n2 = Integer.valueOf(((String[])v)[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return n2;
    }

    public Integer getInteger(String string) {
        return new Integer(this.getInt(string, 0));
    }

    public Integer getInteger(String string, int n) {
        return new Integer(this.getInt(string, n));
    }

    public Integer getInteger(String string, Integer n) {
        return new Integer(this.getInt(string, n));
    }

    public Integer[] getIntegers(String string) {
        Integer[] integerArray = null;
        String[] stringArray = this.getStrings(string);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            integerArray = new Integer[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                integerArray[n] = Integer.valueOf(stringArray2[n]);
                ++n;
            }
        }
        return integerArray;
    }

    public int[] getInts(String string) {
        int[] nArray = null;
        String[] stringArray = this.getStrings(string);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            nArray = new int[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                nArray[n] = Integer.parseInt(stringArray2[n]);
                ++n;
            }
        }
        return nArray;
    }

    public Object[] getKeys() {
        return this.parameters.keySet().toArray();
    }

    public long getLong(String string) {
        return this.getLong(string, 0L);
    }

    public long getLong(String string, long l) {
        long l2 = l;
        try {
            Object v = this.parameters.get(string);
            if (v != null) {
                l2 = Long.valueOf(((String[])v)[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return l2;
    }

    public Long[] getLongObjects(String string) {
        Long[] longArray = null;
        String[] stringArray = this.getStrings(string);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            longArray = new Long[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                longArray[n] = Long.valueOf(stringArray2[n]);
                ++n;
            }
        }
        return longArray;
    }

    public long[] getLongs(String string) {
        long[] lArray = null;
        String[] stringArray = this.getStrings(string);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            lArray = new long[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                lArray[n] = Long.parseLong(stringArray2[n]);
                ++n;
            }
        }
        return lArray;
    }

    public Object getObject(String string) {
        try {
            Object object = null;
            Object v = this.parameters.get(string);
            if (v != null) {
                object = ((Object[])v)[0];
            }
            return object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Object[] getObjects(String string) {
        try {
            return (Object[])this.parameters.get(string);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Map getParametersMap() {
        return this.parameters;
    }

    public String getString(String string) {
        try {
            String string2 = null;
            Object v = this.parameters.get(string);
            if (v != null) {
                string2 = ((String[])v)[0];
            }
            if (string2 == null || string2.equals("null")) {
                return null;
            }
            return string2;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public String getString(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null || string3.length() == 0 || string3.equals("null")) {
            return string2;
        }
        return string3;
    }

    public String[] getStrings(String string) {
        String[] stringArray = null;
        Object v = this.parameters.get(string);
        if (v != null) {
            stringArray = (String[])v;
        }
        return stringArray;
    }

    public String[] getStrings(String string, String[] stringArray) {
        String[] stringArray2 = this.getStrings(string);
        if (stringArray2 == null || stringArray2.length == 0) {
            return stringArray;
        }
        return stringArray2;
    }

    public Iterator keys() {
        return this.parameters.keySet().iterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append('{');
            stringBuffer.append(string);
            stringBuffer.append('=');
            String[] stringArray = (String[])this.parameters.get(string);
            if (stringArray == null) {
                stringBuffer.append("null");
            } else if (stringArray.length == 1) {
                stringBuffer.append(stringArray[0]);
            } else {
                int n = 0;
                while (n < stringArray.length) {
                    if (n != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append('[');
                    stringBuffer.append(stringArray[n]);
                    stringBuffer.append(']');
                    ++n;
                }
            }
            stringBuffer.append("}\n");
        }
        return stringBuffer.toString();
    }
}

