/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.plexus.summit.parameters.RequestParameters;
import org.codehaus.plexus.summit.rundata.RunData;

public class UriBuilder {
    public static final String ROLE = (class$org$codehaus$plexus$summit$util$UriBuilder == null ? (class$org$codehaus$plexus$summit$util$UriBuilder = UriBuilder.class$("org.codehaus.plexus.summit.util.UriBuilder")) : class$org$codehaus$plexus$summit$util$UriBuilder).getName();
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final int ANCHOR_STATIC_PART_LENGTH = "<a href=\"\"></a>".length();
    protected RunData data = null;
    public HttpServletResponse res = null;
    protected ArrayList pathInfo = new ArrayList();
    protected ArrayList queryData = new ArrayList();
    protected boolean redirect = false;
    protected static final int PATH_INFO = 0;
    protected static final int QUERY_DATA = 1;
    private boolean isRelative = false;
    private boolean encodeUrl = true;
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static boolean[] safe = new boolean[128];
    static /* synthetic */ Class class$org$codehaus$plexus$summit$util$UriBuilder;

    public UriBuilder() {
    }

    public UriBuilder(RunData data) {
        this.init(data);
    }

    public void init() {
        this.pathInfo.clear();
        this.queryData.clear();
    }

    public void init(RunData data) {
        this.data = data;
        this.res = this.data.getResponse();
        this.init();
    }

    protected void add(int type, String name, String value) {
        Object[] tmp = new Object[]{name, value};
        if (type == 0) {
            this.pathInfo.add(tmp);
        } else if (type == 1) {
            this.queryData.add(tmp);
        }
    }

    protected void addPair(ArrayList list, String name, String value) {
        Object[] tmp = new Object[]{name, value};
        list.add(tmp);
    }

    protected void add(ArrayList list, RequestParameters pp) {
        Iterator itr = pp.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (key.equalsIgnoreCase("action") || key.equalsIgnoreCase("target")) continue;
            String[] values = pp.getStrings(key);
            int i = 0;
            while (i < values.length) {
                this.addPair(list, key, values[i]);
                ++i;
            }
        }
    }

    protected void add(int type, RequestParameters pp) {
        if (type == 0) {
            this.add(this.pathInfo, pp);
        } else if (type == 1) {
            this.add(this.queryData, pp);
        }
    }

    public UriBuilder addPathInfo(String name, Object value) {
        this.addPathInfo(name, value.toString());
        return this;
    }

    public UriBuilder addPathInfo(String name, String value) {
        this.addPair(this.pathInfo, name, value);
        return this;
    }

    public UriBuilder addPathInfo(String name, double value) {
        this.addPathInfo(name, Double.toString(value));
        return this;
    }

    public UriBuilder addPathInfo(String name, int value) {
        this.addPathInfo(name, new Integer(value).toString());
        return this;
    }

    public UriBuilder addPathInfo(String name, long value) {
        this.addPathInfo(name, new Long(value).toString());
        return this;
    }

    public UriBuilder addPathInfo(String name, boolean value) {
        this.addPathInfo(name, value ? "true" : "false");
        return this;
    }

    public UriBuilder addPathInfo(RequestParameters pp) {
        this.add(this.pathInfo, pp);
        return this;
    }

    public UriBuilder addQueryData(String name, Object value) {
        this.addQueryData(name, value.toString());
        return this;
    }

    public UriBuilder addQueryData(String name, String value) {
        this.addPair(this.queryData, name, value);
        return this;
    }

    public UriBuilder addQueryData(String name, double value) {
        this.addQueryData(name, Double.toString(value));
        return this;
    }

    public UriBuilder addQueryData(String name, int value) {
        this.addQueryData(name, new Integer(value).toString());
        return this;
    }

    public UriBuilder addQueryData(String name, long value) {
        this.addQueryData(name, new Long(value).toString());
        return this;
    }

    public UriBuilder addQueryData(RequestParameters pp) {
        this.add(this.queryData, pp);
        return this;
    }

    public String getA(String name) {
        String s = this.toString();
        int size = ANCHOR_STATIC_PART_LENGTH + s.length() + name.length();
        return new StringBuffer(size).append("<a href=\"").append(s).append("\">").append(name).append("</a>").toString();
    }

    public String getScriptName() {
        return this.data.getScriptName();
    }

    public String getServerName() {
        return this.data.getServerName();
    }

    public int getServerPort() {
        return this.data.getServerPort();
    }

    public String getServerScheme() {
        return this.data.getServerScheme();
    }

    protected void remove(int type, String name) {
        try {
            if (type == 0) {
                this.removePathInfo(name);
            } else if (type == 1) {
                this.removeQueryData(name);
            }
        }
        catch (Exception e) {}
    }

    protected void removePairByName(ArrayList pairs, String name) {
        int i = 0;
        while (i < pairs.size()) {
            Object[] pair = (Object[])pairs.get(i);
            if (name.equals((String)pair[0])) {
                pairs.remove(i);
            }
            ++i;
        }
    }

    public void removePathInfo() {
        this.pathInfo.clear();
    }

    public void removePathInfo(String name) {
        this.removePairByName(this.pathInfo, name);
    }

    public void removeQueryData() {
        this.queryData.clear();
    }

    public void removeQueryData(String name) {
        this.removePairByName(this.queryData, name);
    }

    protected String renderPathInfo(Vector data) {
        StringBuffer out = new StringBuffer();
        this.renderPathInfo(new ArrayList(data), out);
        return out.toString();
    }

    protected void renderPathInfo(ArrayList pairs, StringBuffer out) {
        this.renderPairs(pairs, out, '/', '/');
    }

    protected String renderQueryString(Vector data) {
        StringBuffer out = new StringBuffer();
        this.renderQueryString(new ArrayList(data), out);
        return out.toString();
    }

    protected void renderQueryString(ArrayList data, StringBuffer out) {
        this.renderPairs(data, out, '&', '=');
    }

    protected void renderPairs(ArrayList pairs, StringBuffer out, char pairSep, char keyValSep) {
        boolean first = true;
        int count = pairs.size();
        int i = 0;
        while (i < count) {
            Object[] pair = (Object[])pairs.get(i);
            if (first) {
                first = false;
            } else {
                out.append(pairSep);
            }
            UriBuilder.writeFastEncoded((String)pair[0], out);
            out.append(keyValSep);
            UriBuilder.writeFastEncoded((String)pair[1], out);
            ++i;
        }
    }

    public UriBuilder setAction(String action) {
        this.addPathInfo("action", action);
        return this;
    }

    public UriBuilder setTarget(String template) {
        this.addPathInfo("target", template);
        return this;
    }

    public UriBuilder setRedirect(boolean doRedirect) {
        this.redirect = doRedirect;
        return this;
    }

    public UriBuilder setRelative(boolean b) {
        this.isRelative = b;
        return this;
    }

    public boolean isRelative() {
        return this.isRelative;
    }

    public UriBuilder setEncodeUrl(boolean b) {
        this.encodeUrl = b;
        return this;
    }

    public boolean isEncodeUrl() {
        return this.encodeUrl;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        if (!this.isRelative()) {
            output.append(this.data.getServerScheme());
            output.append("://");
            output.append(this.data.getServerName());
            if (this.data.getServerScheme().equals(HTTP) && this.data.getServerPort() != 80 || this.data.getServerScheme().equals(HTTPS) && this.data.getServerPort() != 443) {
                output.append(':');
                output.append(this.data.getServerPort());
            }
        }
        output.append(this.data.getContextPath());
        output.append(this.data.getScriptName());
        if (this.hasPathInfo()) {
            output.append('/');
            this.renderPathInfo(this.pathInfo, output);
        }
        if (this.hasQueryData()) {
            output.append('?');
            this.renderQueryString(this.queryData, output);
        }
        if (this.res != null && this.isEncodeUrl()) {
            if (this.redirect) {
                return this.res.encodeRedirectURL(output.toString());
            }
            return this.res.encodeURL(output.toString());
        }
        return output.toString();
    }

    public static String toString(RunData data) {
        return UriBuilder.toString(data, true);
    }

    public static String toString(RunData data, boolean isAbsolute) {
        StringBuffer output = new StringBuffer(128);
        HttpServletRequest request = data.getRequest();
        if (isAbsolute) {
            output.append(data.getServerScheme());
            output.append("://");
            output.append(data.getServerName());
            if (data.getServerScheme().equals(HTTP) && data.getServerPort() != 80 || data.getServerScheme().equals(HTTPS) && data.getServerPort() != 443) {
                output.append(':');
                output.append(data.getServerPort());
            }
        }
        output.append(data.getContextPath());
        output.append(data.getScriptName());
        if (request.getPathInfo() != null) {
            output.append(request.getPathInfo());
        }
        if (request.getQueryString() != null) {
            output.append('?');
            output.append(request.getQueryString());
        }
        return output.toString();
    }

    protected static final void writeFastEncoded(String in, StringBuffer out) {
        if (in == null || in.length() == 0) {
            out.append("null");
            return;
        }
        char[] chars = in.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c < '\u0080' && safe[c]) {
                out.append(c);
            } else if (c == ' ') {
                out.append('+');
            } else {
                UriBuilder.writeEncoded(new String(chars, i, chars.length - i), out);
                break;
            }
            ++i;
        }
    }

    protected static final void writeEncoded(String in, StringBuffer out) {
        if (in == null || in.length() == 0) {
            out.append("null");
            return;
        }
        byte[] bytes = in.getBytes();
        int i = 0;
        while (i < bytes.length) {
            char c = (char)bytes[i];
            if (c < '\u0080' && safe[c]) {
                out.append(c);
            } else if (c == ' ') {
                out.append('+');
            } else {
                byte toEscape = bytes[i];
                out.append('%');
                int low = toEscape & 0xF;
                int high = (toEscape & 0xF0) >> 4;
                out.append(hexadecimal[high]);
                out.append(hexadecimal[low]);
            }
            ++i;
        }
    }

    public boolean hasPathInfo() {
        return !this.pathInfo.isEmpty();
    }

    public boolean hasQueryData() {
        return !this.queryData.isEmpty();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i = 97;
        while (i <= 122) {
            UriBuilder.safe[i] = true;
            ++i;
        }
        int i2 = 65;
        while (i2 <= 90) {
            UriBuilder.safe[i2] = true;
            ++i2;
        }
        int i3 = 48;
        while (i3 <= 57) {
            UriBuilder.safe[i3] = true;
            ++i3;
        }
        UriBuilder.safe[45] = true;
        UriBuilder.safe[95] = true;
        UriBuilder.safe[46] = true;
        UriBuilder.safe[33] = true;
        UriBuilder.safe[126] = true;
        UriBuilder.safe[42] = true;
        UriBuilder.safe[39] = true;
        UriBuilder.safe[40] = true;
        UriBuilder.safe[41] = true;
    }
}

