/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.resolver;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.codehaus.plexus.summit.module.Module;
import org.codehaus.plexus.summit.resolver.AbstractResolver;
import org.codehaus.plexus.summit.resolver.Resolution;
import org.codehaus.plexus.summit.view.View;

public class SimpleResolver
extends AbstractResolver {
    public static final String SCREEN_MODULE = "screenModule";
    public static final String SCREEN_VIEW = "screenView";
    public static final String DEFAULT_SCREEN_MODULE_KEY = "defaultScreenModule";
    public static final String DEFAULT_SCREEN_MODULE = "Default";
    private String defaultScreenModule;

    public void setDefaultScreenModule(String defaultScreenModule) {
        this.defaultScreenModule = defaultScreenModule;
    }

    public String getDefaultScreenModule() {
        return this.defaultScreenModule;
    }

    public Resolution resolve(String target) throws Exception {
        Resolution resolution = new Resolution();
        Module screenModule = this.getScreenModule(target);
        resolution.put(SCREEN_MODULE, screenModule);
        this.getLogger().info("Found screen module: " + screenModule);
        View screenView = this.getView(target);
        resolution.put(SCREEN_VIEW, screenView);
        this.getLogger().info("Found screen view: " + screenView);
        return resolution;
    }

    protected Module getScreenModule(String target) throws Exception {
        return this.getModule(target, null, this.getDefaultScreenModule());
    }

    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        this.setDefaultScreenModule(config.getChild(DEFAULT_SCREEN_MODULE_KEY).getValue(DEFAULT_SCREEN_MODULE));
    }
}

