/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.resolver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.codehaus.plexus.summit.AbstractSummitComponent;
import org.codehaus.plexus.summit.module.Module;
import org.codehaus.plexus.summit.renderer.Renderer;
import org.codehaus.plexus.summit.resolver.Resolution;
import org.codehaus.plexus.summit.resolver.Resolver;
import org.codehaus.plexus.summit.resolver.ResolverUtils;
import org.codehaus.plexus.summit.view.DefaultView;
import org.codehaus.plexus.summit.view.View;

public abstract class AbstractResolver
extends AbstractSummitComponent
implements Resolver,
Configurable,
ThreadSafe {
    private List modulePackages = new ArrayList();
    private StringBuffer modulePackagesNames = new StringBuffer();
    private String errorView;
    private String defaultView;
    private String defaultBaseName;
    private String defaultViewExtension;

    public void configure(Configuration config) throws ConfigurationException {
        this.setDefaultView(config.getChild("defaultView").getValue());
        this.setErrorView(config.getChild("errorView").getValue());
        this.setDefaultBaseName(config.getChild("defaultBaseName").getValue());
        this.setDefaultViewExtension(config.getChild("defaultViewExtension").getValue());
        Configuration[] packages = config.getChild("modulePackages").getChildren();
        if (packages == null || packages.length == 0) {
            this.addModulePackage("");
        } else {
            int i = 0;
            while (i < packages.length) {
                this.getLogger().info("Adding package " + packages[i].getValue());
                this.addModulePackage(packages[i].getValue());
                ++i;
            }
        }
    }

    void setDefaultView(String defaultView) {
        this.defaultView = defaultView;
    }

    public String getDefaultView() {
        return this.defaultView;
    }

    void setErrorView(String errorView) {
        this.errorView = errorView;
    }

    public String getErrorView() {
        return this.errorView;
    }

    void setDefaultBaseName(String defaultBaseName) {
        this.defaultBaseName = defaultBaseName;
    }

    public String getDefaultBaseName() {
        return this.defaultBaseName;
    }

    void setDefaultViewExtension(String defaultViewExtension) {
        this.defaultViewExtension = defaultViewExtension;
    }

    public String getDefaultViewExtension() {
        return this.defaultViewExtension;
    }

    void setModulePackages(List modulePackages) {
        this.modulePackages = modulePackages;
    }

    public List getModulePackages() {
        return this.modulePackages;
    }

    void addModulePackage(String modulePackage) {
        this.modulePackages.add(modulePackage);
        this.modulePackagesNames.append(modulePackage).append("\n");
    }

    protected View getView(String target) throws Exception {
        return this.getView(target, null, null);
    }

    protected View getView(String target, String targetPrefix) throws Exception {
        return this.getView(target, targetPrefix, null);
    }

    protected View getView(String target, String targetPrefix, String defaultView) throws Exception {
        List possibleViews = this.getPossibleViews(target, targetPrefix);
        Renderer renderer = (Renderer)this.getServiceManager().lookup(Renderer.ROLE);
        if (defaultView != null && defaultView.length() > 0) {
            possibleViews.add(defaultView);
        }
        Iterator i = possibleViews.iterator();
        while (i.hasNext()) {
            String view = (String)i.next();
            this.getLogger().info("Looking for view: " + view);
            if (this.getServiceManager() == null || !renderer.viewExists(view)) continue;
            this.getLogger().info("Found view: " + view);
            return new DefaultView(view);
        }
        return null;
    }

    List getPossibleViews(String target, String targetPrefix) throws Exception {
        ArrayList<String> views = new ArrayList<String>();
        List possibleViews = ResolverUtils.getPossibleViews(target, this.getDefaultBaseName());
        Iterator i = possibleViews.iterator();
        while (i.hasNext()) {
            String possibleView = (String)i.next();
            String view = targetPrefix != null && targetPrefix.length() > 0 ? targetPrefix + "/" + possibleView : possibleView;
            view = view + "." + this.getDefaultViewExtension();
            views.add(view);
        }
        return views;
    }

    public void clearModulePackages() {
        int size = this.modulePackages.size();
        int i = 0;
        while (i < size) {
            this.modulePackages.remove(0);
            ++i;
        }
    }

    Module getModule(String target) throws Exception {
        return this.getModule(target, null, null);
    }

    Module getModule(String target, String targetPrefix) throws Exception {
        return this.getModule(target, targetPrefix, null);
    }

    Module getModule(String target, String targetPrefix, String defaultModule) throws Exception {
        Module module = null;
        List possibleModules = this.getPossibleModules(target, targetPrefix);
        if (defaultModule != null && defaultModule.length() > 0) {
            possibleModules.add(defaultModule);
        }
        Iterator i = possibleModules.iterator();
        while (i.hasNext()) {
            String moduleClass = (String)i.next();
            try {
                this.getLogger().debug("[Resolver] Looking for " + moduleClass);
                module = (Module)Class.forName(moduleClass).newInstance();
                this.getLogger().debug("[Resolver] " + target + " => " + moduleClass);
                break;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return module;
    }

    List getPossibleModules(String target, String targetPrefix) throws Exception {
        ArrayList<String> modules = new ArrayList<String>();
        List moduleSuffixes = ResolverUtils.getPossibleModuleSuffixes(target, this.getDefaultBaseName());
        Iterator i = this.modulePackages.iterator();
        while (i.hasNext()) {
            String modulePackage = (String)i.next();
            Iterator j = moduleSuffixes.iterator();
            while (j.hasNext()) {
                String module = targetPrefix != null && targetPrefix.length() > 0 ? modulePackage + "." + targetPrefix + "." + j.next() : modulePackage + "." + j.next();
                modules.add(module);
            }
        }
        return modules;
    }

    public abstract Resolution resolve(String var1) throws Exception;
}

