/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.renderer;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.summit.exception.SummitException;
import org.codehaus.plexus.summit.rundata.RunData;
import org.codehaus.plexus.util.ExceptionUtils;

public class JspRenderer
extends AbstractLogEnabled {
    private int bufferSize = 8192;
    protected RunData data = null;

    public JspRenderer(RunData data) {
        this.data = data;
    }

    public int getDefaultBufferSize() {
        return this.bufferSize;
    }

    public void render(String jsp) throws SummitException {
        this.render(jsp, false);
    }

    public void render(String jsp, boolean isForward) throws SummitException {
        block4: {
            String jspPath = "/templates/jsp/" + jsp;
            this.getLogger().debug("Jsp to render: " + jspPath);
            if (jspPath == null) {
                throw new SummitException("JSP " + jsp + " not found in specified paths");
            }
            RequestDispatcher dispatcher = this.data.getServletConfig().getServletContext().getRequestDispatcher(jspPath);
            this.data.getResponse().setBufferSize(this.bufferSize);
            this.data.getResponse().setContentType("text/html");
            try {
                if (isForward) {
                    dispatcher.forward((ServletRequest)this.data.getRequest(), (ServletResponse)this.data.getResponse());
                    break block4;
                }
                dispatcher.include((ServletRequest)this.data.getRequest(), (ServletResponse)this.data.getResponse());
            }
            catch (Exception e) {
                this.getLogger().error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }
}

