/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.pipeline.valve;

import java.io.IOException;
import org.apache.avalon.framework.service.ServiceException;
import org.codehaus.plexus.summit.exception.SummitException;
import org.codehaus.plexus.summit.pipeline.valve.AbstractValve;
import org.codehaus.plexus.summit.pipeline.valve.ValveContext;
import org.codehaus.plexus.summit.resolver.Resolver;
import org.codehaus.plexus.summit.rundata.RunData;

public class DetermineTargetValve
extends AbstractValve {
    public void invoke(RunData data, ValveContext context) throws IOException, SummitException {
        if (!data.hasTarget()) {
            String target = data.getParameters().getString("target");
            if (target != null) {
                data.setTarget(target);
                this.getLogger().info("Setting target from request parameter: " + target);
            } else {
                target = this.getResolver(data).getDefaultView();
                data.setTarget(target);
                this.getLogger().info("Setting target using default value: " + data.getTarget());
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Target is now: " + data.getTarget());
        }
        context.invokeNext(data);
    }

    private Resolver getResolver(RunData data) throws SummitException {
        try {
            return (Resolver)this.getServiceManager().lookup(Resolver.ROLE);
        }
        catch (ServiceException e) {
            throw new SummitException("Could not get a Resolver", e);
        }
    }
}

